﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TokenPlanFixer.BillingService;
using System.ServiceModel;
using System.Configuration;
using System.Xml;
using Vindicia;
using System.Threading;
using Curse.Billing.Configuration;

namespace TokenPlanFixer
{
    internal static class CancelExpiredGCSubs
    {
        internal static void CancelExpired()
        {

            DataProvider dp = new DataProvider();
            List<string> subscriptionIDs = dp.GetSubscriptionIDsNeedingExpiration();
            VindiciaConfiguration.Initialize();

            Console.WriteLine(string.Format("Processing {0} Subscriptions", subscriptionIDs.Count));
            int successCount = 0;
            foreach (string subID in subscriptionIDs)
            {
                try
                {
                    AutoBill autobill = new AutoBill();
                    Return r = autobill.fetchByMerchantAutoBillId(subID);

                    if (r.returnCode == ReturnCode.Item200)
                    {
                        Console.WriteLine(string.Format("{0}({1})", autobill.merchantAutoBillId, autobill.VID));
                        Return cancelReturn = autobill.cancel(true, true);
                        if (cancelReturn.returnCode == ReturnCode.Item200)
                        {
                            Console.WriteLine("\tCancelled");
                            successCount++;
                        }
                        else
                        {
                            Console.WriteLine("\tFAILED to cancel - " + cancelReturn.returnString);
                        }
                            
                    } else {
                        Console.WriteLine(string.Format("Failed to retrieve - {0}", subID));
                    }
                } catch(Exception e)  {

                    Console.WriteLine(e.Message);
                    Console.WriteLine(e.StackTrace);
                }
            }
            Console.WriteLine(string.Format("Successfully cancelled {0} / {1} subscriptions", successCount, subscriptionIDs.Count));
            Console.ReadLine();
        }
    }
}
