﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;

namespace TokenPlanFixer
{
    public class DataProvider
    {
        /// <summary>
        /// Returns an unopened sql connection string
        /// </summary>
        /// <returns></returns>
        protected SqlConnection GetSqlConnection()
        {

            try
            {
                string connStr = ConfigurationManager.ConnectionStrings["BillingService"].ConnectionString;
                return new SqlConnection(connStr);
            }
            catch
            {
                throw new Exception("SQL Connection String is invalid.");
            }

        }

        public List<string> GetSubscriptionIDsWithoutBilling(string billingPlanID)
        {
            List<string> subIDs = new List<string>();

            using (SqlConnection myConnection = GetSqlConnection())
            {
                using (SqlCommand myCommand = new SqlCommand("SELECT SubscriptionID FROM Subscription WHERE NextBillDate IS NULL AND BillingPlanID = @billingPlanID AND STATUS = 0 ORDER BY ID DESC", myConnection))
                {
                    myCommand.CommandType = CommandType.Text;

                    // Add parameters
                    //
                    myCommand.Parameters.Add("@billingPlanID", SqlDbType.VarChar).Value = billingPlanID;
                    // Execute the command
                    myConnection.Open();
                    using (SqlDataReader dr = myCommand.ExecuteReader())
                    {
                        while (dr.Read())
                        {
                            subIDs.Add(dr[0] as string);
                        }
                    }
                    myConnection.Close();
                }
            }

            return subIDs;
        }


        internal List<string> GetSubscriptionIDsNeedingExpiration()
        {
            List<string> subIDs = new List<string>();

            using (SqlConnection myConnection = GetSqlConnection())
            {
                using (SqlCommand myCommand = new SqlCommand("select sub.SubscriptionID from Subscription sub where Status = 0 AND sub.DateExpires <  GETUTCDATE() AND NextBillDate IS NULL", myConnection))
                {
                    myCommand.CommandType = CommandType.Text;
                    // Execute the command
                    myConnection.Open();
                    using (SqlDataReader dr = myCommand.ExecuteReader())
                    {
                        while (dr.Read())
                        {
                            subIDs.Add(dr[0] as string);
                        }
                    }
                    myConnection.Close();
                }
            }

            return subIDs;
        }

        internal List<string> GetAccountsWithExpiredEntitlements()
        {
            List<string> subIDs = new List<string>();

            using (SqlConnection myConnection = GetSqlConnection())
            {
                using (SqlCommand myCommand = new SqlCommand("SELECT DISTINCT AccountID From AccountEntitlement WITH (nolock) WHERE DateExpires < Dateadd(day, 1, GETUTCDATE())", myConnection))
                {
                    myCommand.CommandType = CommandType.Text;
                    // Execute the command
                    myConnection.Open();
                    using (SqlDataReader dr = myCommand.ExecuteReader())
                    {
                        while (dr.Read())
                        {
                            subIDs.Add(dr[0] as string);
                        }
                    }
                    myConnection.Close();
                }
            }

            return subIDs;
        }

        internal List<string> GetAccountsWithExpiredEntitlementsAndActiveSubscriptions()
        {
            List<string> subIDs = new List<string>();

            using (SqlConnection myConnection = GetSqlConnection())
            {
                using (SqlCommand myCommand = new SqlCommand("spGetAccountsNeedingEntitlementSync",
                    myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    // Execute the command
                    myConnection.Open();
                    using (SqlDataReader dr = myCommand.ExecuteReader())
                    {
                        while (dr.Read())
                        {
                            subIDs.Add(dr[0] as string);
                        }
                    }
                    myConnection.Close();
                }
            }

            return subIDs;
        }
        internal List<string> GetAccountsWithActiveSubscriptions()
        {
            List<string> subIDs = new List<string>();

            using (SqlConnection myConnection = GetSqlConnection())
            {
                using (SqlCommand myCommand = new SqlCommand("select distinct accountid from subscription s where s.status = 0",
                    myConnection))
                {
                    myCommand.CommandType = CommandType.Text;
                    // Execute the command
                    myConnection.Open();
                    using (SqlDataReader dr = myCommand.ExecuteReader())
                    {
                        while (dr.Read())
                        {
                            subIDs.Add(dr[0] as string);
                        }
                    }
                    myConnection.Close();
                }
            }

            return subIDs;
        }

        internal List<string> GetDelayedAccountsSincePromo()
        {
            List<string> subIDs = new List<string>();

            using (SqlConnection myConnection = GetSqlConnection())
            {
                using (SqlCommand myCommand = new SqlCommand("select distinct s.SubscriptionID from Subscription s where s.ProductID = 'GH' AND s.BillingPlanID LIKE '%-D'and s.DateStarted > '7/19/2011'and s.Status = 0", myConnection))
                {
                    myCommand.CommandType = CommandType.Text;
                    // Execute the command
                    myConnection.Open();
                    using (SqlDataReader dr = myCommand.ExecuteReader())
                    {
                        while (dr.Read())
                        {
                            subIDs.Add(dr[0] as string);
                        }
                    }
                    myConnection.Close();
                }
            }

            return subIDs;

        }
    }
}
