﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TokenPlanFixer.BillingService;
using System.ServiceModel;
using System.Configuration;
using System.Xml;
using Vindicia;
using System.Threading;
using Curse.Billing.Configuration;

namespace TokenPlanFixer
{
    internal static class FixPaymentMethod
    {
        internal static void FixPaymentMethods() {
            const string TokenCurrencyStr = "_VT";

            DataProvider dp = new DataProvider();
            List<string> subscriptionIDs = dp.GetSubscriptionIDsWithoutBilling("GH-T");
            VindiciaConfiguration.Initialize();
            Token ghToken = new Token() { merchantTokenId = "GH" };
            ghToken.fetch();

            Console.WriteLine(string.Format("Processing {0} Subscriptions", subscriptionIDs.Count));
            int successCount = 0;
            foreach (string subID in subscriptionIDs)
            {
                try
                {
                    AutoBill autobill = new AutoBill();
                    Return r = autobill.fetchByMerchantAutoBillId(subID);

                    if (r.returnCode == ReturnCode.Item200)
                    {
                        Console.WriteLine(string.Format("{0}({1})", autobill.merchantAutoBillId, autobill.VID));                       

                        Account account = autobill.account;
                        Return acctRet = account.fetchByVid(account.VID);

                        var test = account.paymentMethods.Where(pm => pm.currency == TokenCurrencyStr);
                        PaymentMethod tokenMethod = account.paymentMethods.FirstOrDefault(pm => pm.token != null && pm.token.merchantTokenId == "GH");
                        if (tokenMethod == null)
                        {
                            string pmId = string.Format("{0}-{1}", account.merchantAccountId, DateTime.UtcNow.Ticks);
                            tokenMethod = new PaymentMethod()
                            {
                                merchantPaymentMethodId = pmId,
                                accountHolderName = account.name,
                                active = true,
                                currency = TokenCurrencyStr,
                                type = PaymentMethodType.Token,
                                token = ghToken,
                                sortOrder = 0,//account.paymentMethods.Length,
                                customerDescription = "Autogenerated token method",
                                billingAddress = account.shippingAddress,
                            };

                            bool validated;
                            Account proxyAccount = new Account();
                            proxyAccount.merchantAccountId = account.merchantAccountId;
                            Return ret = proxyAccount.updatePaymentMethod(tokenMethod, false, PaymentUpdateBehavior.Update, 0, out validated);

                            if (ret.returnCode == ReturnCode.Item200)
                            {
                                Return fetchPmRet = tokenMethod.fetchByMerchantPaymentMethodId(pmId);
                                if (fetchPmRet.returnCode == ReturnCode.Item200)
                                {
                                    Console.WriteLine(string.Format("\tCreated Token Payment Method {0} ({1})", pmId, tokenMethod.VID));
                                }
                                else
                                {
                                    Console.WriteLine("\tFAILED to fetch Token Payment Method: " + pmId);
                                    //throw new Exception("The payment method could not be added");
                                }
                            }
                            else
                            {
                                Console.WriteLine("\tFAILED to create Token Payment Method");
                            }
                        } else {
                            Console.WriteLine("\tFound payment method: " + tokenMethod.VID);
                            if (tokenMethod.currency != TokenCurrencyStr)
                            {
                                tokenMethod.currency = TokenCurrencyStr;
                                Account proxyAccount = new Account();
                                proxyAccount.merchantAccountId = account.merchantAccountId;
                                bool validated;
                                Return ret = proxyAccount.updatePaymentMethod(tokenMethod, false, PaymentUpdateBehavior.Update, 0, out validated);
                                if (ret.returnCode == ReturnCode.Item200)
                                {
                                    Console.WriteLine("\t\tUpdated currency to _VT");
                                }
                                else
                                {
                                    Console.WriteLine("\t\tUnable to update currency: " + ret.returnString);
                                }
                            }
                        }

                        // Fix the autobill

                        AutoBill fixedAb = new AutoBill()
                        {
                            VID = autobill.VID,
                            paymentMethod = tokenMethod,
                            status = AutoBillStatus.Active,
                            startTimestamp = autobill.startTimestamp
                        };

                        bool created = false;
                        bool validatePayment = false;
                        int minChargeBackProb = 100;
                        TransactionStatus transactionStatus;
                        DateTime firstBillDate;
                        decimal firstBillAmount;
                        string firstBillCurrency;
                        int score;
                        ScoreCode[] scoreCodes;
                        Return abUpdateRet = fixedAb.update(DuplicateBehavior.Fail, true, validatePayment, minChargeBackProb, out created, out transactionStatus, out firstBillDate, out firstBillAmount, out firstBillCurrency, out score, out scoreCodes);
                        if (abUpdateRet.returnCode == ReturnCode.Item200)
                        {
                            Console.WriteLine("\tUpdated!!");
                            successCount++;
                        }
                        else
                        {
                            Console.WriteLine(string.Format("\tFAILED to update {0}: {1}", subID, abUpdateRet.returnString));
                        }
                            
                    } else {
                        Console.WriteLine(string.Format("Failed to retrieve - {0}", subID));
                    }
                } catch(Exception e)  {

                    Console.WriteLine(e.Message);
                    Console.WriteLine(e.StackTrace);
                }
            }
            Console.WriteLine(string.Format("Successfully updated {0} / {1} subscriptions", successCount, subscriptionIDs.Count));
            Console.ReadLine();
        }
    }
}
