﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TokenPlanFixer.BillingService;
using System.IO;

namespace TokenPlanFixer
{
    internal static class ProductDumper
    {
        public static void WriteProductBillingPlanList()
        {
            
            BillingProvider bp = new BillingProvider();

            BillingServiceClient client = bp.GetBillingServiceClient();


            var offerings = client.GetAllProductOfferings();

            if (offerings.Status == ServiceResponseStatus.Successful)
            {
                FileStream fs = new FileStream("C:\\Curse\\BillingPlans.csv", FileMode.OpenOrCreate);
                StreamWriter sw = new StreamWriter(fs);
                foreach (ProductOffering offering in offerings.Value)
                {
                    foreach (ProductBillingPlan plan in offering.AvailableBillingPlans) {
                        sw.WriteLine(string.Format("{0},{1},{2},{3},{4},{5}", offering.ID, plan.ID, plan.Description, plan.FirstPayPeriod.Days, plan.FirstPayPeriod.Prices.First().Amount, plan.FirstPayPeriod.Prices.First().Currency));
                    }
                }
                sw.Flush();
                sw.Close();
                fs.Close();
            }
        }
    }
}
