﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Vindicia;

namespace TokenPlanFixer
{
    internal static class SubscriptionCredit
    {
        internal static void Credit(IEnumerable<string> subscriptionIDs, int daysToCredit)
        {
            int successCount = 0;
            foreach (string subID in subscriptionIDs)
            {
                try
                {
                    AutoBill autobill = new AutoBill();
                    Return r = autobill.fetchByMerchantAutoBillId(subID);

                    if (r.returnCode == ReturnCode.Item200)
                    {
                        Console.WriteLine(string.Format("{0}({1})", autobill.merchantAutoBillId, autobill.VID));
                    }
                    else
                    {
                        Console.WriteLine(string.Format("Failed to retrieve - {0}", subID));
                    }

                    DateTime nextBillingDate;
                    Decimal nextBillingAmount;
                    string nextBillingCurrency;

                    // Attempt to delay auto billing
                    Return sr = autobill.delayBillingByDays(daysToCredit, true, out nextBillingDate, out nextBillingAmount, out nextBillingCurrency);
                    if (r.returnCode == ReturnCode.Item200)
                    {
                        Console.WriteLine(string.Format("\tCredited"));
                    }
                    else
                    {
                        Console.WriteLine(string.Format("\tFAILED"));
                    }

                }
                catch (Exception e)
                {

                    Console.WriteLine(e.Message);
                    Console.WriteLine(e.StackTrace);
                }
            }
            Console.WriteLine(string.Format("Successfully updated {0} / {1} subscriptions", successCount, subscriptionIDs.Count()));
            Console.ReadLine();

        }
    }
}
