﻿using System;
using System.Configuration;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;

namespace CurseReportingService
{
    public class ClientReporter : BaseReportableDatabase
    {

        public ClientReporter()
        {
            sConnectionString = ConfigurationManager.ConnectionStrings["Client"].ConnectionString;
        }
        
        public int GetNewUserCount(DateTime pFromDate, DateTime pToDate)
        {
            object newUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from logged_user where first_seen between @fromDate and @toDate";
                
                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;
                
                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                newUserCount = cmd.ExecuteScalar();
            }

            return (int)newUserCount;
        }

        public int GetRecentUserCount(DateTime pFromDate)
        {
            object recentUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from logged_user where last_seen >= @fromDate";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                recentUserCount = cmd.ExecuteScalar();
            }

            return (int)recentUserCount;
        }



        public int GetTotalUserCount(bool pActiveOnly)
        {

            object totalUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();

                cmd.CommandText = "select count(distinct(user_id)) from installed_addon with(nolock)";
                
                if(pActiveOnly)
                {
                    cmd.CommandText += "where posted >= DATEADD(MONTH, -1, GETUTCDATE());";
                }

                totalUserCount = cmd.ExecuteScalar();
            }

            return (int)totalUserCount;
           
        }

        public Dictionary<string, int> GetTotalUserCountWithAgent(bool pActiveOnly, DateTime pFromDate, DateTime pToDate)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select top 10 version_name, count(0) as total from logged_user inner join client_version on client_version.version_id = logged_user.version_id where version_name like '%CurseClient%'";
                if (pActiveOnly)
                {
                    cmd.CommandText += " and last_seen between @fromDate and @toDate";
                }
                cmd.CommandText += " group by version_name order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    int total = 0;
                    while (reader.Read())
                    {
                        total = reader.GetInt32(1);
                        if (total >= 10)
                        {
                            newUserCount.Add(reader.GetString(0), total);
                        }
                    }
                }
            }

            return newUserCount;
        }        
    }
}
