﻿using System;
using System.Configuration;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;

namespace CurseReportingService
{
    public class AuthReporter : BaseReportableDatabase
    {

        public AuthReporter()
        {
            sConnectionString = ConfigurationManager.ConnectionStrings["Auth"].ConnectionString;
        }
        
        public int GetNewUserCount(DateTime pFromDate, DateTime pToDate)
        {
            object newUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from userprofiles where _registeredOn between @fromDate and @toDate";
                
                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;
                
                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                newUserCount = cmd.ExecuteScalar();
            }

            return (int)newUserCount;
        }

        public Dictionary<string, int> GetNewUserCountWithSite(DateTime pFromDate, DateTime pToDate)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            
            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select sites._name as name, count(0) as total from userprofiles with(nolock) inner join sites with(nolock) on sites._id = userprofiles._registeredVia where _registeredOn between '" + pFromDate.ToString() + "' and '" + pToDate + "' group by _name order by total desc;";

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        newUserCount.Add(reader.GetString(0), reader.GetInt32(1));
                    }
                }
            }

            return newUserCount;
        }

        public int GetNewSubscriptionCount(DateTime pFromDate, DateTime pToDate, bool activeOnly, bool payedOnly)
        {
            object newSubCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from usersubscriptions where _subscribed between @fromDate and @toDate";

                if (activeOnly)
                {
                    cmd.CommandText += " and _expiration > GETUTCDATE()";
                }

                if (payedOnly)
                {
                    cmd.CommandText += " and _level > 0";
                }

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                newSubCount = cmd.ExecuteScalar();
            }

            return (int)newSubCount;
        }

        public Dictionary<string, int> GetNewSubscriptionCountWithType(DateTime pFromDate, DateTime pToDate, bool activeOnly)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select subscriptiontypes._description as description, count(0) as total from usersubscriptions with(nolock) inner join subscriptiontypes with(nolock) on subscriptiontypes._type = usersubscriptions._type and subscriptiontypes._level = usersubscriptions._level where _subscribed between @fromDate and @toDate";
                if (activeOnly)
                {
                    cmd.CommandText += " and _expiration > GETUTCDATE()";
                }
                cmd.CommandText += " group by subscriptiontypes._description order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        newUserCount.Add(reader.GetString(0), reader.GetInt32(1));
                    }
                }
            }

            return newUserCount;
        }

        public string GetUserNameById(int id)
        {
            string name = String.Empty;
            
            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select _username from users where _uid = @uid";

                cmd.Parameters.AddWithValue("@uid", id);

                    var tempName = cmd.ExecuteScalar();
                    if (tempName != null)
                    {
                        name = tempName.ToString();
                    }
                    else
                    {
                        name = "Unknown";
                    }
                
            }

            return name;

        }

    }
}
