﻿using System;
using System.Configuration;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;

namespace CurseReportingService
{
    public class LegacySubscriptionsReporter : BaseReportableDatabase
    {

        public LegacySubscriptionsReporter()
        {
            sConnectionString = ConfigurationManager.ConnectionStrings["LegacySubscriptions"].ConnectionString;
        }



        public int GetSubscriptionCount(DateTime pFromDate, DateTime pToDate, bool activeOnly, bool payedOnly, ESubscriptionAction action)
        {
            object newSubCount = 0;

            List<string> filters = new List<string>();

            filters.Add("signup_date between @fromDate and @toDate");

            if (activeOnly)
            {
                filters.Add("expiration_date > GETUTCDATE()");
            }

            if (payedOnly)
            {
                filters.Add("complimentary = 0");                
            }

            if (action == ESubscriptionAction.New)
            {
                filters.Add("not exists(select top 1 1 from subscription as b where b.user_id = subscription.user_id and b.id <> subscription.id)");
            }
            else if (action == ESubscriptionAction.Renewal)
            {
                filters.Add("exists(select top 1 1 from subscription as b where b.user_id = subscription.user_id and b.id <> subscription.id)");
            }

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select SUM(total) from"
                                + " ("
                                + " select subscription_type.name as name, count(distinct(user_id)) as total"
                                + " from subscription inner join subscription_type on subscription_type.id = subscription.type_id"
                                + " where " + string.Join(" and ", filters.ToArray())
                                + " group by subscription_type.name"
                                + ") as a";

               
                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                newSubCount = cmd.ExecuteScalar();
            }

            if (newSubCount == System.DBNull.Value)
            {
                return 0;
            }
            else
            {
                return (int)newSubCount;
            }
            
        }

        public Dictionary<string, int> GetSubscriptionCountWithType(DateTime pFromDate, DateTime pToDate, bool activeOnly)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select subscription_type.name as name, count(distinct(user_id)) as total from subscription inner join subscription_type on subscription_type.id = subscription.type_id" 
                    + " where signup_date between @fromDate and @toDate";

                if (activeOnly)
                {
                    cmd.CommandText += " and expiration_date > GETUTCDATE()";
                }
                cmd.CommandText += " group by subscription_type.name order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        newUserCount.Add(reader.GetString(0), reader.GetInt32(1));
                    }
                }
            }

            return newUserCount;
        }

    }
}
