﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SQLite;
using System.IO;
using System.Linq;
using System.Net.Mail;
using System.Text;

namespace WORUserEmailer
{
    internal static class Program
    {
        private static void Main(string[] args)
        {
            Console.Title = "Status: 0%";
            SmtpClient smtp = new SmtpClient(@"smtp.notsetyet.com");

            using (SQLiteConnection conn = new SQLiteConnection(@"Data Source=C:\Curse\WORRemap.db"))
            {
                conn.Open();

                SQLiteCommand cmd = conn.CreateCommand();
                cmd.CommandText = "SELECT COUNT(0) FROM remap WHERE result<>2";
                long total = (long)cmd.ExecuteScalar();
                long count = 0;
                long percent = 0;

                cmd.CommandText = "SELECT * FROM remap WHERE result<>2";
                using (SQLiteDataReader dr = cmd.ExecuteReader())
                {
                    while (dr.Read())
                    {
                        long newPercent = (long)(((float)(++count) / total) * 100);
                        if (newPercent != percent)
                        {
                            percent = newPercent;
                            Console.Title = string.Format("Status: {0}%", percent);
                        }

                        bool ok = true;
                        MailMessage msg = new MailMessage("WOR Administrators <no-reply@wowdb.com>",
                                                          (string)dr["email"]);
                        msg.Subject = "Login Changes";
                        msg.BodyEncoding = Encoding.UTF8;
                        try
                        {
                            switch ((int)dr["result"])
                            {
                                case 0:
                                    msg.Body = string.Format(RESULT_0_BODY,
                                                             (string)dr["username"]);
                                    break;
                                case 1:
                                    msg.Body = string.Format(RESULT_1_BODY,
                                                             (string)dr["original_username"],
                                                             (string)dr["username"]);
                                    break;
                                case 3:
                                    msg.Body = string.Format(RESULT_3_BODY,
                                                             (string)dr["original_username"],
                                                             (string)dr["username"]);
                                    break;
                                case 4:
                                    msg.Body = string.Format(RESULT_4_BODY,
                                                             (string)dr["original_username"],
                                                             (string)dr["username"]);
                                    break;
                                default:
                                    ok = false;
                                    break;
                            }
                            if (ok)
                            {
                                smtp.Send(msg);
                            }
                        }
                        catch (Exception)
                        {
                            ok = false;
                        }

                        if (ok)
                        {
                            cmd.CommandText = string.Format("DELETE FROM remap WHERE original_id={0}",
                                                            (int)dr["original_id"]);
                            cmd.ExecuteNonQuery();
                        }
                    }
                }
            }
            Console.WriteLine("Press any key to exit...");
            Console.ReadKey(true);
        }


        private const string RESULT_0_BODY =
            "Hello {0},\n\n" +
            "There have been some recent changes at World of Raids.  The site has not only been redesigned, but also launched on a new technology platform.  " +
            "As part of the redesign, the World of Raids user database was merged with Curse.com’s user database.  " +
            "Our records show that you have an account on both sites with the same username and email address combination.  " +
            "Going forward, in order to login to either site, use the password associated with the account on Curse.com.  " +
            "If you have forgotten your password for that account, you can reset it on this page: http://my.curse.com/account/request-password/\n\n" +
            "If you have any troubles logging into the site, please contact us at this page: http://www.worldofraids.com/forums/sendmessage.php\n\n" +
            "You can now login to all sites (World of Raids, www.curse.com, www.wowdb.com) using the same username and password.  " +
            "Additionally, all future sites will use the same login system to manage accounts.  " +
            "So you’ll no longer have to remember your login credentials and enter new profile information for each site.\n\n" +
            "We hope that you enjoy the new World of Raids and continue to visit us.  " +
            "If you have any feedback regarding the site, please write in our feedback forum: http://worldofraids.com/forums/forumdisplay.php?f=3";

        private const string RESULT_1_BODY =
            "Hello {0},\n\n" +
            "There have been some recent changes at World of Raids.  The site has not only been redesigned, but also launched on a new technology platform.  " +
            "As part of the redesign, the World of Raids user database was merged with Curse.com’s user database.  " +
            "Our records show that you may have an account on both sites based on your email address.  " +
            "However, you have a different username on each site.  " +
            "Going forward, in order to login to either site, login using the username and password associated with the account on Curse.com.  " +
            "That username is {1}.  " +
            "If you have forgotten your password for that account, you can reset it on this page: http://my.curse.com/account/request-password/.  " +
            "If you want to change your username to something else, you can do that here: http://www.worldofraids.com\n\n" +
            "If you have any troubles logging into the site, please contact us at this page: http://www.worldofraids.com/forums/sendmessage.php\n\n" +
            "We apologize for any inconvenience this may cause.  " +
            "We want to ensure that our users have the best possible experience visiting the Curse Network of sites.  " +
            "You can now login to all sites (World of Raids, www.curse.com, www.wowdb.com) using the same username and password.  " +
            "Additionally, all future sites will use the same login system to manage accounts.  " +
            "So you’ll no longer have to remember your login credentials and enter new profile information for each site.\n\n" +
            "We hope that you enjoy the new World of Raids and continue to visit us.  " +
            "If you have any feedback regarding the site, please write in our feedback forum: http://worldofraids.com/forums/forumdisplay.php?f=3";

        private const string RESULT_3_BODY =
            "Hello {0},\n\n" +
            "There have been some recent changes at World of Raids.  The site has not only been redesigned, but also launched on a new technology platform.  " +
            "As part of the redesign, the World of Raids user database was merged with Curse.com’s user database.  " +
            "Accounts were checked both on username and email address.  " +
            "While we had hoped for a seamless transition, some usernames with differing email addresses conflicted.  " +
            "Unfortunately your account conflicted with an existing username.  " +
            "If you already have an account on Curse.com, you can now log into both sites using that account.  " +
            "Otherwise, some action will need to be taken to login into either site.  " +
            "Your username has been set to a temporary username.  " +
            "When you login next, you will be prompted to change your username to something else.  " +
            "Here are useful links:\n\n" +
            "Temporary username: {1}\n" +
            "Click here to login and change your username: http://www.worldofraids.com\n\n" +
            "If you have any troubles logging into the site, please contact us at this page: http://www.worldofraids.com/forums/sendmessage.php\n\n" +
            "We apologize for any inconvenience this may cause.  " +
            "We want to ensure that our users have the best possible experience visiting the Curse Network of sites.  " +
            "You can now login to all sites (World of Raids, www.curse.com, www.wowdb.com) using the same username and password.  " +
            "Additionally, all future sites will use the same login system to manage accounts.  " +
            "So you’ll no longer have to remember your login credentials and enter new profile information for each site.\n\n" +
            "We hope that you enjoy the new World of Raids and continue to visit us.  " +
            "If you have any feedback regarding the site, please write in our feedback forum: http://worldofraids.com/forums/forumdisplay.php?f=3";

        private const string RESULT_4_BODY =
            "Hello {0},\n\n" +
            "There have been some recent changes at World of Raids.  The site has not only been redesigned, but also launched on a new technology platform.  " +
            "As part of the redesign, the World of Raids user database was merged with Curse.com’s user database.  " +
            "Unfortunately your account’s username contains invalid characters in the new system.  " +
            "Your account’s username has been set to a temporary username.  " +
            "When you login next, you will be prompted to change your username to something else.  " +
            "Here are useful links:\n\n" +
            "Temporary username: {1}\n" +
            "Click here to login and change your username: http://www.worldofraids.com\n\n" +
            "If you have any troubles logging into the site, please contact us at this page: http://www.worldofraids.com/forums/sendmessage.php\n\n" +
            "We apologize for any inconvenience this may cause.  " +
            "We want to ensure that our users have the best possible experience visiting the Curse Network of sites.  " +
            "You can now login to all sites (World of Raids, www.curse.com, www.wowdb.com) using the same username and password.  " +
            "Additionally, all future sites will use the same login system to manage accounts.  " +
            "So you’ll no longer have to remember your login credentials and enter new profile information for each site.\n\n" +
            "We hope that you enjoy the new World of Raids and continue to visit us.  " +
            "If you have any feedback regarding the site, please write in our feedback forum: http://worldofraids.com/forums/forumdisplay.php?f=3";
    }
}
