﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Data.SQLite;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using MySql.Data.MySqlClient;
using MySql.Data.Types;

namespace AceUserImporter
{
    internal static class Program
    {
        private const int MAX_RANDOM_VALUE = 999999;
        private const string SOURCE_QUERY =
            "SELECT " +
            "ID_MEMBER, memberName, passwd, passwordSalt, realName," +
            "birthdate, gender, location, posts, emailAddress, notifyAnnouncements" +
            " FROM smf_members WHERE passwd!='' AND emailAddress!='' AND is_activated=1" +
            " ORDER BY memberName DESC;";
        private const string USERS_QUERY =
            "INSERT INTO users(" +
            "_username,_password,_level,_salt) " +
            "OUTPUT Inserted._uid " +
            "VALUES(" +
            "{0},NULL,100,NULL);";
        private const string EMAILS_QUERY =
            "INSERT INTO useremails(" +
            "_uid,_email,_verified) " +
            "OUTPUT Inserted._id " +
            "VALUES(" +
            "{0},{1},1);";
        private const string PROFILES_QUERY =
            "INSERT INTO userprofiles(" +
            "_uid,_firstName,_lastName," +
            "_birthDate,_gender,_defaultEmail," +
            "_country,_region,_city," +
            "_wantsmail,_registeredVia,_posts) VALUES(" +
            "{0},{1},{2}," +
            "{3},{4},{5}," +
            "{6},{7},{8}," +
            "{9},{10},{11});";
        private const string LEGACY_QUERY =
            "INSERT INTO userlegacy(" +
            "_uid,_site,_renamed,_password,_salt) VALUES(" +
            "{0},{1},{2},{3},{4});";
        private const string RENAMES_QUERY =
            "INSERT INTO userrenames VALUES({0});"; 

        private static void Main(string[] args)
        {
            string date;
            DateTime dt;
            List<User> users = new List<User>();
            List<int> insertedUsers = new List<int>();
            SQLiteConnection.CreateFile(Properties.Settings.Default.SQLiteDB);
            Console.Title = "Status: 0%";
            using (SQLiteConnection liteConn = new SQLiteConnection(String.Format("Data Source={0}", Properties.Settings.Default.SQLiteDB)))
            {
                liteConn.Open();
                SQLiteCommand liteCmd = liteConn.CreateCommand();
                liteCmd.CommandText = "CREATE TABLE IF NOT EXISTS remap (" +
                                      "original_id INT," +
                                      "new_id INT," +
                                      "original_username," +
                                      "username," +
                                      "email," +
                                      "result INT)";
                liteCmd.ExecuteNonQuery();
                liteCmd.Transaction = liteConn.BeginTransaction();

                using (MySqlConnection myConn = new MySqlConnection(Properties.Settings.Default.SourceDB))
                {
                    myConn.Open();
                    MySqlCommand myCmd = new MySqlCommand(SOURCE_QUERY, myConn);

                    Console.Write("Loading Users...");
                    using (MySqlDataReader myDR = myCmd.ExecuteReader())
                    {
                        while (myDR.Read())
                        {
                            User u = new User();
                            u.OriginalId = (int)((uint)myDR["ID_MEMBER"]);
                            u.Username = ((string)myDR["memberName"]).ToLower();
                            u.Password = (string)myDR["passwd"];
                            u.PasswordSalt = (string)myDR["passwordSalt"];
                            u.FirstName = (string)myDR["realName"];
                            try
                            {
                                u.BirthDate = (DateTime)myDR["birthdate"];
                            }
                            catch (Exception e)
                            {
                                u.BirthDate = DateTime.MinValue;
                            }
                            if (u.BirthDate < new DateTime(1900, 1, 1))
                            {
                                u.BirthDate = new DateTime(1900, 1, 1);
                            }
                            u.Gender = (byte)((byte)myDR["gender"] == 0 ? 1 : 2);
                            u.City = (string)myDR["location"];
                            if (u.City.Length > 32)
                            {
                                u.City = u.City.Substring(0, 32);
                            }
                            u.Email = ((string)myDR["emailAddress"]).ToLower();
                            u.Newsletter = (sbyte)myDR["notifyAnnouncements"] != 0;
                            u.Posts = (int)((uint)myDR["posts"]);

                            users.Add(u);
                        }
                    }
                    Console.WriteLine("Done.");
                }
                
                using (SqlConnection msConn = new SqlConnection(Properties.Settings.Default.DestinationDB))
                {
                    msConn.Open();
                    SqlCommand msCmd = new SqlCommand();
                    msCmd.Connection = msConn;
                    msCmd.Transaction = msConn.BeginTransaction();
                    StringBuilder sql = new StringBuilder();
                    Regex userPattern = new Regex("^[a-zA-Z0-9_]+$", RegexOptions.Compiled);
                    Random rnd = new Random();
                    object uid;
                    object emailid;
                    string username;
                    int count = 0;
                    int percent = 0;

                    Console.Write("Importing Users...");
                    foreach (User u in users)
                    {
                        int newPercent = (int)(((float)(++count) / users.Count) * 100);
                        if (newPercent != percent)
                        {
                            percent = newPercent;
                            Console.Title = string.Format("Status: {0}%", percent);
                        }

                        // Check if the email already exists in useremails
                        msCmd.CommandText = string.Format("SELECT _uid FROM useremails WHERE _email={0};",
                                                          EscapeAndQuote(u.Email));

                        // If the email is already in useremails, we can consollidate the accounts
                        if ((uid = msCmd.ExecuteScalar()) != null)
                        {
                            u.NewId = (int)uid;
                            if (u.Posts > 0)
                            {
                                msCmd.CommandText = string.Format("UPDATE userprofiles SET _posts=_posts+{0} WHERE _uid={1};",
                                                                  u.Posts,
                                                                  (int)uid);
                                msCmd.ExecuteNonQuery();
                            }
                            msCmd.CommandText = string.Format("SELECT _username FROM users WHERE _uid={0};",
                                                              (int)uid);
                            username = ((string)msCmd.ExecuteScalar()).ToLower();
                            if (u.Username == username)
                            {
                                // If the username is the same, simply inform the user that their password for Ace will be their curse password
                                liteCmd.CommandText = string.Format("INSERT INTO remap VALUES({0},{1},NULL,'{2}',{3},0)",
                                                                    u.OriginalId,
                                                                    u.NewId,
                                                                    u.Username,
                                                                    EscapeAndQuote(u.Email));
                            }
                            else
                            {
                                // If the username is different, inform the user that their username and password for Ace will be their curse username and password
                                liteCmd.CommandText = string.Format("INSERT INTO remap VALUES({0},{1},{2},'{3}',{4},1)",
                                                                    u.OriginalId,
                                                                    u.NewId,
                                                                    EscapeAndQuote(u.Username),
                                                                    username,
                                                                    EscapeAndQuote(u.Email));
                                u.Username = username;
                                if (!insertedUsers.Contains(u.NewId))
                                {
                                    // Give users who had same email, but different usernames an opportunity to rename themselves if they so desire
                                    msCmd.CommandText = string.Format(RENAMES_QUERY,
                                                                      u.NewId);
                                    try
                                    {
                                        msCmd.ExecuteNonQuery();
                                    }
                                    catch (Exception e)
                                    {
                                        // if they're already in there, it's all good.
                                    }
                                    insertedUsers.Add(u.NewId);
                                }
                            }
                            liteCmd.ExecuteNonQuery();
                            continue;
                        }

                        bool badUsername = false;
                        // The account could not be consollidated with an existing curse account, so we need to verify the username is valid
                        if (u.Username.Length < 2 ||
                            u.Username.Length > 32 ||
                            !userPattern.IsMatch(u.Username))
                        {
                            // Username is not valid, set the bad username for email reference and generate a username
                            badUsername = true;
                            u.OriginalUsername = u.Username;
                            u.Username = string.Format("user_{0}", rnd.Next(0, MAX_RANDOM_VALUE));
                        }

                        // Verify that the username we're trying to use doesn't already exist
                        msCmd.CommandText = string.Format("SELECT COUNT(0) FROM users WHERE _username={0};",
                                                          EscapeAndQuote(u.Username));
                        int i = 1;
                        while ((int)msCmd.ExecuteScalar() != 0)
                        {
                            // Username exists
                            // Conflicts with existing user that we cannot verify is the same person, OR
                            // Generated username is already in use
                            if (u.OriginalUsername.Length == 0)
                            {
                                // If the bad username isn't set, then this is a username conflict
                                // So we add to the changedUsers for an email telling them their new username
                                u.OriginalUsername = u.Username;
                            }
                            if (i == 1)
                            {
                                u.Username = string.Format("{0}", u.Username);
                            }
                            else
                            {
                                string betterUsername = u.Username;
                                if (betterUsername.Length + i.ToString().Length > 32)
                                {
                                    betterUsername = betterUsername.Substring(0, 32 - i.ToString().Length);
                                }
                                u.Username = string.Format("{0}{1}", betterUsername, i);
                            }
                            i++;

                            // Keep checking until the username isn't used
                            msCmd.CommandText = string.Format("SELECT COUNT(0) FROM users WHERE _username={0};",
                                                              EscapeAndQuote(u.Username));
                        }

                        // Update the users table
                        sql.Length = 0;
                        sql.AppendFormat(USERS_QUERY,
                                         EscapeAndQuote(u.Username));
                        msCmd.CommandText = sql.ToString();
                        uid = msCmd.ExecuteScalar();
                        u.NewId = (int)uid;

                        // Update the useremails table
                        sql.Length = 0;
                        sql.AppendFormat(EMAILS_QUERY,
                                         (int)uid,
                                         EscapeAndQuote(u.Email));
                        msCmd.CommandText = sql.ToString();
                        emailid = msCmd.ExecuteScalar();

                        // Update the userprofiles table
                        sql.Length = 0;
                        sql.AppendFormat(PROFILES_QUERY,
                                         (int)uid,
                                         EscapeAndQuote(u.FirstName),
                                         u.LastName.Length == 0 ? "NULL" : EscapeAndQuote(u.LastName),
                                         u.BirthDate == DateTime.MinValue ? "NULL" : EscapeAndQuote(u.BirthDate.ToString("yyyy-MM-dd")),
                                         u.Gender,
                                         (int)emailid,
                                         "'US'",
                                         u.Region.Length == 0 ? "NULL" : EscapeAndQuote(u.Region),
                                         u.City.Length == 0 ? "NULL" : EscapeAndQuote(u.City),
                                         u.Newsletter ? "1" : "0",
                                         Properties.Settings.Default.SiteID,
                                         u.Posts);
                        msCmd.CommandText = sql.ToString();
                        msCmd.ExecuteNonQuery();

                        // Update the userlegacy table
                        sql.Length = 0;
                        sql.AppendFormat(LEGACY_QUERY,
                                         (int)uid,
                                         Properties.Settings.Default.SiteID,
                                         u.OriginalUsername.Length > 0 ? "1" : "0",
                                         EscapeAndQuote(u.Password),
                                         EscapeAndQuote(u.PasswordSalt));
                        msCmd.CommandText = sql.ToString();
                        msCmd.ExecuteNonQuery();

                        string result = "2";
                        if (u.OriginalUsername.Length > 0)
                        {
                            result = !badUsername ? "3" : "4";
                        }
                        liteCmd.CommandText = string.Format("INSERT INTO remap VALUES({0},{1},{2},'{3}',{4},{5})",
                                                            u.OriginalId,
                                                            u.NewId,
                                                            EscapeAndQuote(u.OriginalUsername),
                                                            u.Username,
                                                            EscapeAndQuote(u.Email),
                                                            result);
                        liteCmd.ExecuteNonQuery();
                    }
                    msCmd.Transaction.Commit();
                    liteCmd.Transaction.Commit();
                    Console.WriteLine("Done.");
                }
            }

            Console.WriteLine("Imported {0} Users.", users.Count);
            Console.ReadKey();
        }

        private static String EscapeAndQuote(String pValue)
        {
            return "'" + pValue.Replace("'", "''") + "'";
        }
    }
}
