﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace WoWDataCompare
{
    public static partial class DB
    {
        public static void ProcessCreature()
        {
            Int32 totalNotFound = 0;
            Int32 totalDifferences = 0;
            using (SqlConnection conn = new SqlConnection(Properties.Settings.Default.Database))
            {
                conn.Open();
                SqlCommand cmdTest = conn.CreateCommand();

                cmdTest.CommandText = String.Format(sCreatureTestSelectQueryFormat,
                                                    Properties.Settings.Default.TestVersion);

                using (SqlDataReader drTest = cmdTest.ExecuteReader())
                {
                    while (drTest.Read())
                    {
                        SqlCommand cmdBase = conn.CreateCommand();
                        cmdBase.CommandText = String.Format(sCreatureBaseSelectQueryFormat,
                                                            (Int32)drTest[0],
                                                            Properties.Settings.Default.BaseVersion);
                        using (SqlDataReader drBase = cmdBase.ExecuteReader())
                        {
                            if (!drBase.Read())
                            {
                                ++totalNotFound;
                                continue;
                            }

                            Int32 firstDifference = -1;
                            Int32 differences = 0;
                            for (Int32 index = 0; index < sCreatureCompareCount; ++index)
                            {
                                if (!drTest[index + 1].Equals(drBase[index]))
                                {
                                    if (firstDifference < 0)
                                    {
                                        firstDifference = index;
                                    }
                                    ++differences;
                                }
                            }
                            totalDifferences += differences;
                            if (differences > 0)
                            {
                                Console.WriteLine("Creature ID {0} had {1} difference(s), first difference in column '{2}'",
                                                  drTest[0],
                                                  differences,
                                                  drBase.GetName(firstDifference));
                            }
                        }
                    }
                }
            }
            if (totalNotFound > 0)
            {
                Console.WriteLine("{0} creatures in the test version that do not exist in the base version.", totalNotFound);
            }
            if (totalDifferences > 0)
            {
                Console.WriteLine("{0} differences between the test version and the base version.", totalDifferences);
            }
        }

        public static void ProcessGameObject()
        {
            Int32 totalNotFound = 0;
            Int32 totalDifferences = 0;
            using (SqlConnection conn = new SqlConnection(Properties.Settings.Default.Database))
            {
                conn.Open();
                SqlCommand cmdTest = conn.CreateCommand();

                cmdTest.CommandText = String.Format(sGameObjectTestSelectQueryFormat,
                                                    Properties.Settings.Default.TestVersion);

                using (SqlDataReader drTest = cmdTest.ExecuteReader())
                {
                    while (drTest.Read())
                    {
                        SqlCommand cmdBase = conn.CreateCommand();
                        cmdBase.CommandText = String.Format(sGameObjectBaseSelectQueryFormat,
                                                            (Int32)drTest[0],
                                                            Properties.Settings.Default.BaseVersion);
                        using (SqlDataReader drBase = cmdBase.ExecuteReader())
                        {
                            if (!drBase.Read())
                            {
                                ++totalNotFound;
                                continue;
                            }

                            Int32 firstDifference = -1;
                            Int32 differences = 0;
                            for (Int32 index = 0; index < sGameObjectCompareCount; ++index)
                            {
                                if (!drTest[index + 1].Equals(drBase[index]))
                                {
                                    if (firstDifference < 0)
                                    {
                                        firstDifference = index;
                                    }
                                    ++differences;
                                }
                            }
                            totalDifferences += differences;
                            if (differences > 0)
                            {
                                Console.WriteLine("GameObject ID {0} had {1} difference(s), first difference in column '{2}'",
                                                  drTest[0],
                                                  differences,
                                                  drBase.GetName(firstDifference));
                            }
                        }
                    }
                }
            }
            if (totalNotFound > 0)
            {
                Console.WriteLine("{0} game objects in the test version that do not exist in the base version.", totalNotFound);
            }
            if (totalDifferences > 0)
            {
                Console.WriteLine("{0} differences between the test version and the base version.", totalDifferences);
            }
        }

        public static void ProcessItem()
        {
            Int32 totalNotFound = 0;
            Int32 totalDifferences = 0;
            using (SqlConnection conn = new SqlConnection(Properties.Settings.Default.Database))
            {
                conn.Open();
                SqlCommand cmdTest = conn.CreateCommand();

                cmdTest.CommandText = String.Format(sItemTestSelectQueryFormat,
                                                    Properties.Settings.Default.TestVersion);

                using (SqlDataReader drTest = cmdTest.ExecuteReader())
                {
                    while (drTest.Read())
                    {
                        SqlCommand cmdBase = conn.CreateCommand();
                        cmdBase.CommandText = String.Format(sItemBaseSelectQueryFormat,
                                                            (Int32)drTest[0],
                                                            Properties.Settings.Default.BaseVersion);
                        using (SqlDataReader drBase = cmdBase.ExecuteReader())
                        {
                            if (!drBase.Read())
                            {
                                ++totalNotFound;
                                continue;
                            }

                            Int32 firstDifference = -1;
                            Int32 differences = 0;
                            for (Int32 index = 0; index < sItemCompareCount; ++index)
                            {
                                if (!drTest[index + 1].Equals(drBase[index]))
                                {
                                    if (firstDifference < 0)
                                    {
                                        firstDifference = index;
                                    }
                                    ++differences;
                                }
                            }
                            totalDifferences += differences;
                            if (differences > 0)
                            {
                                Console.WriteLine("Item ID {0} had {1} difference(s), first difference in column '{2}'",
                                                  drTest[0],
                                                  differences,
                                                  drBase.GetName(firstDifference));
                            }
                        }
                    }
                }
            }
            if (totalNotFound > 0)
            {
                Console.WriteLine("{0} items in the test version that do not exist in the base version.", totalNotFound);
            }
            if (totalDifferences > 0)
            {
                Console.WriteLine("{0} differences between the test version and the base version.", totalDifferences);
            }
        }

        public static void ProcessPageText()
        {
            Int32 totalNotFound = 0;
            Int32 totalDifferences = 0;
            using (SqlConnection conn = new SqlConnection(Properties.Settings.Default.Database))
            {
                conn.Open();
                SqlCommand cmdTest = conn.CreateCommand();

                cmdTest.CommandText = String.Format(sPageTextTestSelectQueryFormat,
                                                    Properties.Settings.Default.TestVersion);

                using (SqlDataReader drTest = cmdTest.ExecuteReader())
                {
                    while (drTest.Read())
                    {
                        SqlCommand cmdBase = conn.CreateCommand();
                        cmdBase.CommandText = String.Format(sPageTextBaseSelectQueryFormat,
                                                            (Int32)drTest[0],
                                                            Properties.Settings.Default.BaseVersion);
                        using (SqlDataReader drBase = cmdBase.ExecuteReader())
                        {
                            if (!drBase.Read())
                            {
                                ++totalNotFound;
                                continue;
                            }

                            Int32 firstDifference = -1;
                            Int32 differences = 0;
                            for (Int32 index = 0; index < sPageTextCompareCount; ++index)
                            {
                                if (!drTest[index + 1].Equals(drBase[index]))
                                {
                                    if (firstDifference < 0)
                                    {
                                        firstDifference = index;
                                    }
                                    ++differences;
                                }
                            }
                            totalDifferences += differences;
                            if (differences > 0)
                            {
                                Console.WriteLine("PageText ID {0} had {1} difference(s), first difference in column '{2}'",
                                                  drTest[0],
                                                  differences,
                                                  drBase.GetName(firstDifference));
                            }
                        }
                    }
                }
            }
            if (totalNotFound > 0)
            {
                Console.WriteLine("{0} page texts in the test version that do not exist in the base version.", totalNotFound);
            }
            if (totalDifferences > 0)
            {
                Console.WriteLine("{0} differences between the test version and the base version.", totalDifferences);
            }
        }

        public static void ProcessQuest()
        {
            Int32 totalNotFound = 0;
            Int32 totalDifferences = 0;
            using (SqlConnection conn = new SqlConnection(Properties.Settings.Default.Database))
            {
                conn.Open();
                SqlCommand cmdTest = conn.CreateCommand();

                cmdTest.CommandText = String.Format(sQuestTestSelectQueryFormat,
                                                    Properties.Settings.Default.TestVersion);

                using (SqlDataReader drTest = cmdTest.ExecuteReader())
                {
                    while (drTest.Read())
                    {
                        SqlCommand cmdBase = conn.CreateCommand();
                        cmdBase.CommandText = String.Format(sQuestBaseSelectQueryFormat,
                                                            (Int32)drTest[0],
                                                            Properties.Settings.Default.BaseVersion);
                        using (SqlDataReader drBase = cmdBase.ExecuteReader())
                        {
                            if (!drBase.Read())
                            {
                                ++totalNotFound;
                                continue;
                            }

                            Int32 firstDifference = -1;
                            Int32 differences = 0;
                            for (Int32 index = 0; index < sQuestCompareCount; ++index)
                            {
                                if (!drTest[index + 1].Equals(drBase[index]))
                                {
                                    if (firstDifference < 0)
                                    {
                                        firstDifference = index;
                                    }
                                    ++differences;
                                }
                            }
                            totalDifferences += differences;
                            if (differences > 0)
                            {
                                Console.WriteLine("Quest ID {0} had {1} difference(s), first difference in column '{2}'",
                                                  drTest[0],
                                                  differences,
                                                  drBase.GetName(firstDifference));
                            }
                        }
                    }
                }
            }
            if (totalNotFound > 0)
            {
                Console.WriteLine("{0} quests in the test version that do not exist in the base version.", totalNotFound);
            }
            if (totalDifferences > 0)
            {
                Console.WriteLine("{0} differences between the test version and the base version.", totalDifferences);
            }
        }
    }
}
