﻿using System;

namespace WoWDataCompare
{
    public static partial class DB
    {
        private const Int32 sCreatureCompareCount = 11;
        private const Int32 sGameObjectCompareCount = 4;
        private const Int32 sItemCompareCount = 124;
        private const Int32 sPageTextCompareCount = 2;
        private const Int32 sQuestCompareCount = 56;

        private const String sCreatureTestSelectQueryFormat =
            "SELECT " +
            "id,name_en,description_en,creature_type,family,flag," +
            "spell_data,display1,display2,display3,display4,faction " +
            "FROM creature WHERE version_id={0};";
        private const String sCreatureBaseSelectQueryFormat =
            "SELECT " +
            "name_en,description_en,creature_type,family,flag," +
            "spell_data,display1,display2,display3,display4,faction " +
            "FROM creature WHERE id={0} AND version_id={1};";

        private const String sGameObjectTestSelectQueryFormat =
            "SELECT " +
            "id,type,display_info,name_en,lock_id " +
            "FROM gameobject WHERE version_id={0};";
        private const String sGameObjectBaseSelectQueryFormat =
            "SELECT " +
            "type,display_info,name_en,lock_id " +
            "FROM gameobject WHERE id={0} AND version_id={1};";

        private const String sItemTestSelectQueryFormat =
            "SELECT " +
            "id,name_en,description_en,item_class,item_sub_class,display,quality,item_type," +
            "buy_price,sell_price,slot,required_class,required_race,level,required_level," +
            "required_skill_id,required_skill_level,required_spell_id," +
            "required_rank,required_faction,required_faction_level," +
            "stack_unique,stack_normal,container_slots," +
            "stat_1,stat_1_value," +
            "stat_2,stat_2_value," +
            "stat_3,stat_3_value," +
            "stat_4,stat_4_value," +
            "stat_5,stat_5_value," +
            "stat_6,stat_6_value," +
            "stat_7,stat_7_value," +
            "stat_8,stat_8_value," +
            "stat_9,stat_9_value," +
            "stat_10,stat_10_value," +
            "spell_1,spell_1_trigger,spell_1_charges,spell_1_cooldown,spell_1_category,spell_1_category_cooldown," +
            "spell_2,spell_2_trigger,spell_2_charges,spell_2_cooldown,spell_2_category,spell_2_category_cooldown," +
            "spell_3,spell_3_trigger,spell_3_charges,spell_3_cooldown,spell_3_category,spell_3_category_cooldown," +
            "spell_4,spell_4_trigger,spell_4_charges,spell_4_cooldown,spell_4_category,spell_4_category_cooldown," +
            "spell_5,spell_5_trigger,spell_5_charges,spell_5_cooldown,spell_5_category,spell_5_category_cooldown," +
            "damage_1_min,damage_1_max,damage_1_type," +
            "damage_2_min,damage_2_max,damage_2_type," +
            "damage_3_min,damage_3_max,damage_3_type," +
            "damage_4_min,damage_4_max,damage_4_type," +
            "damage_5_min,damage_5_max,damage_5_type," +
            "resist_physical,resist_holy,resist_fire,resist_nature,resist_frost,resist_shadow,resist_arcane," +
            "weapon_speed,ammo_type,range_modifier,bond," +
            "book_text,book_pages,book_stationary," +
            "begin_quest,required_lockpick_level,material,sheath," +
            "random_1_property,random_2_property," +
            "block,itemset,durability,area,area_map,bag_family_id,totem_category," +
            "socket_1_color,socket_2_color,socket_3_color," +
            "spell_item_enchantment,gem_properties,item_extended_cost,item_condextended_cost," +
            "disenchant_skill_level,armor_damage_modifier " +
            "FROM item WHERE version_id={0};";
        private const String sItemBaseSelectQueryFormat =
            "SELECT " +
            "name_en,description_en,item_class,item_sub_class,display,quality,item_type," +
            "buy_price,sell_price,slot,required_class,required_race,level,required_level," +
            "required_skill_id,required_skill_level,required_spell_id," +
            "required_rank,required_faction,required_faction_level," +
            "stack_unique,stack_normal,container_slots," +
            "stat_1,stat_1_value," +
            "stat_2,stat_2_value," +
            "stat_3,stat_3_value," +
            "stat_4,stat_4_value," +
            "stat_5,stat_5_value," +
            "stat_6,stat_6_value," +
            "stat_7,stat_7_value," +
            "stat_8,stat_8_value," +
            "stat_9,stat_9_value," +
            "stat_10,stat_10_value," +
            "spell_1,spell_1_trigger,spell_1_charges,spell_1_cooldown,spell_1_category,spell_1_category_cooldown," +
            "spell_2,spell_2_trigger,spell_2_charges,spell_2_cooldown,spell_2_category,spell_2_category_cooldown," +
            "spell_3,spell_3_trigger,spell_3_charges,spell_3_cooldown,spell_3_category,spell_3_category_cooldown," +
            "spell_4,spell_4_trigger,spell_4_charges,spell_4_cooldown,spell_4_category,spell_4_category_cooldown," +
            "spell_5,spell_5_trigger,spell_5_charges,spell_5_cooldown,spell_5_category,spell_5_category_cooldown," +
            "damage_1_min,damage_1_max,damage_1_type," +
            "damage_2_min,damage_2_max,damage_2_type," +
            "damage_3_min,damage_3_max,damage_3_type," +
            "damage_4_min,damage_4_max,damage_4_type," +
            "damage_5_min,damage_5_max,damage_5_type," +
            "resist_physical,resist_holy,resist_fire,resist_nature,resist_frost,resist_shadow,resist_arcane," +
            "weapon_speed,ammo_type,range_modifier,bond," +
            "book_text,book_pages,book_stationary," +
            "begin_quest,required_lockpick_level,material,sheath," +
            "random_1_property,random_2_property," +
            "block,itemset,durability,area,area_map,bag_family_id,totem_category," +
            "socket_1_color,socket_2_color,socket_3_color," +
            "spell_item_enchantment,gem_properties,item_extended_cost,item_condextended_cost," +
            "disenchant_skill_level,armor_damage_modifier " +
            "FROM item WHERE id={0} AND version_id={1};";

        private const String sPageTextTestSelectQueryFormat =
            "SELECT " +
            "id,text_en,next_page_id " +
            "FROM pagetext WHERE version_id={0};";
        private const String sPageTextBaseSelectQueryFormat =
            "SELECT " +
            "text_en,next_page_id " +
            "FROM pagetext WHERE id={0} AND version_id={1};";

        private const String sQuestTestSelectQueryFormat =
            "SELECT " +
            "id,name_en,description_en,details_en,sub_description_en," +
            "objective_1_en,objective_2_en,objective_3_en,objective_4_en," +
            "level,area,info,faction,faction_amount,next_quest," +
            "coins,sub_exp_coins_70,reward_spell," +
            "effect_on_player,starting_item,flags," +
            "given_item_1,given_item_1_amount," +
            "given_item_2,given_item_2_amount," +
            "given_item_3,given_item_3_amount," +
            "given_item_4,given_item_4_amount," +
            "choice_item_1,choice_item_1_amount," +
            "choice_item_2,choice_item_2_amount," +
            "choice_item_3,choice_item_3_amount," +
            "choice_item_4,choice_item_4_amount," +
            "choice_item_5,choice_item_5_amount," +
            "choice_item_6,choice_item_6_amount," +
            "kill_creature_1,kill_creature_1_amount,collect_item_1,collect_item_1_amount," +
            "kill_creature_2,kill_creature_2_amount,collect_item_2,collect_item_2_amount," +
            "kill_creature_3,kill_creature_3_amount,collect_item_3,collect_item_3_amount," +
            "kill_creature_4,kill_creature_4_amount,collect_item_4,collect_item_4_amount " +
            "FROM quest WHERE version_id={0};";
        private const String sQuestBaseSelectQueryFormat =
            "SELECT " +
            "name_en,description_en,details_en,sub_description_en," +
            "objective_1_en,objective_2_en,objective_3_en,objective_4_en," +
            "level,area,info,faction,faction_amount,next_quest," +
            "coins,sub_exp_coins_70,reward_spell," +
            "effect_on_player,starting_item,flags," +
            "given_item_1,given_item_1_amount," +
            "given_item_2,given_item_2_amount," +
            "given_item_3,given_item_3_amount," +
            "given_item_4,given_item_4_amount," +
            "choice_item_1,choice_item_1_amount," +
            "choice_item_2,choice_item_2_amount," +
            "choice_item_3,choice_item_3_amount," +
            "choice_item_4,choice_item_4_amount," +
            "choice_item_5,choice_item_5_amount," +
            "choice_item_6,choice_item_6_amount," +
            "kill_creature_1,kill_creature_1_amount,collect_item_1,collect_item_1_amount," +
            "kill_creature_2,kill_creature_2_amount,collect_item_2,collect_item_2_amount," +
            "kill_creature_3,kill_creature_3_amount,collect_item_3,collect_item_3_amount," +
            "kill_creature_4,kill_creature_4_amount,collect_item_4,collect_item_4_amount " +
            "FROM quest WHERE id={0} AND version_id={1};";
    }
}
