﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using MySql.Data.MySqlClient;

namespace WoWMigrator
{
    internal static class Program
    {
        private static void Main(string[] args)
        {
            using (MySqlConnection myConn = new MySqlConnection(Properties.Settings.Default.SourceDB))
            {
                myConn.Open();
                using (SqlConnection sqlConn = new SqlConnection(Properties.Settings.Default.DestinationDB))
                {
                    sqlConn.Open();

                    MySqlCommand myCmd = myConn.CreateCommand();
                    SqlCommand sqlCmd = sqlConn.CreateCommand();
                    
                    sqlCmd.Transaction = sqlConn.BeginTransaction();
                    ImportServers(myCmd, sqlCmd);

                    sqlCmd.Transaction = sqlConn.BeginTransaction();
                    ImportGuilds(myCmd, sqlCmd);

                    sqlCmd.Transaction = sqlConn.BeginTransaction();
                    ImportPlayers(myCmd, sqlCmd);
                    
                    sqlCmd.Transaction = sqlConn.BeginTransaction();
                    ImportFriends(myCmd, sqlCmd);
                }
            }
            Console.ReadKey(true);
        }

        private static void ImportServers(MySqlCommand pMyCmd, SqlCommand pSqlCmd)
        {
            Console.Write("Importing Servers...");
            pSqlCmd.CommandText = "SET IDENTITY_INSERT server ON";
            pSqlCmd.ExecuteNonQuery();

            pMyCmd.CommandText = "SELECT COUNT(0) FROM wow_database_servers";
            long total = (long)pMyCmd.ExecuteScalar();
            long count = 0;
            long percent = 0;

            pMyCmd.CommandText = "SELECT id,name FROM wow_database_servers ORDER BY id ASC";
            using (MySqlDataReader myDR = pMyCmd.ExecuteReader())
            {
                while (myDR.Read())
                {
                    pSqlCmd.CommandText = string.Format("INSERT INTO server(id,name) VALUES({0},N{1})",
                                                        (uint)myDR["id"],
                                                        EscapeAndQuote((string)myDR["name"]));
                    pSqlCmd.ExecuteNonQuery();

                    long newPercent = (long)(((float)(++count) / total) * 100);
                    if (newPercent != percent)
                    {
                        percent = newPercent;
                        Console.Title = string.Format("Status: {0}%", percent);
                    }
                }
            }

            pSqlCmd.CommandText = "SET IDENTITY_INSERT server OFF";
            pSqlCmd.ExecuteNonQuery();
            pSqlCmd.Transaction.Commit();
            Console.WriteLine("Done.");
        }

        private static void ImportGuilds(MySqlCommand pMyCmd, SqlCommand pSqlCmd)
        {
            Console.Write("Importing Guilds...");
            pSqlCmd.CommandText = "SET IDENTITY_INSERT guild ON";
            pSqlCmd.ExecuteNonQuery();

            pMyCmd.CommandText = "SELECT COUNT(0) FROM wow_database_playerguilds";
            long total = (long)pMyCmd.ExecuteScalar();
            long count = 0;
            long percent = 0;

            pMyCmd.CommandText = "SELECT id,name,server FROM wow_database_playerguilds ORDER BY id ASC";
            using (MySqlDataReader myDR = pMyCmd.ExecuteReader())
            {
                while (myDR.Read())
                {
                    pSqlCmd.CommandText = string.Format("INSERT INTO guild(id,name,server_id) VALUES({0},N{1},{2})",
                                                        (uint)myDR["id"],
                                                        EscapeAndQuote((string)myDR["name"]),
                                                        (uint)myDR["server"]);
                    pSqlCmd.ExecuteNonQuery();

                    long newPercent = (long)(((float)(++count) / total) * 100);
                    if (newPercent != percent)
                    {
                        percent = newPercent;
                        Console.Title = string.Format("Status: {0}%", percent);
                    }
                }
            }

            pSqlCmd.CommandText = "SET IDENTITY_INSERT guild OFF";
            pSqlCmd.ExecuteNonQuery();
            pSqlCmd.Transaction.Commit();
            Console.WriteLine("Done.");
        }

        private static void ImportPlayers(MySqlCommand pMyCmd, SqlCommand pSqlCmd)
        {
            Console.Write("Importing Players...");
            pSqlCmd.CommandText = "SET IDENTITY_INSERT player ON";
            pSqlCmd.ExecuteNonQuery();

            pMyCmd.CommandText = "SELECT COUNT(0) FROM wow_database_playerprofiles";
            long total = (long)pMyCmd.ExecuteScalar();
            long count = 0;
            long percent = 0;

            pMyCmd.CommandText = "SELECT id,name,server,owner,guild FROM wow_database_playerprofiles ORDER BY id ASC";
            using (MySqlDataReader myDR = pMyCmd.ExecuteReader())
            {
                while (myDR.Read())
                {
                    pSqlCmd.CommandText = string.Format("INSERT INTO player(id,name,server_id,owner_id,guild_id) VALUES({0},N{1},{2},{3},{4})",
                                                        (uint)myDR["id"],
                                                        EscapeAndQuote((string)myDR["name"]),
                                                        (uint)myDR["server"],
                                                        (uint)myDR["owner"],
                                                        (uint)myDR["guild"]);
                    pSqlCmd.ExecuteNonQuery();

                    long newPercent = (long)(((float)(++count) / total) * 100);
                    if (newPercent != percent)
                    {
                        percent = newPercent;
                        Console.Title = string.Format("Status: {0}%", percent);
                    }
                }
            }

            pSqlCmd.CommandText = "SET IDENTITY_INSERT player OFF";
            pSqlCmd.ExecuteNonQuery();
            pSqlCmd.Transaction.Commit();
            Console.WriteLine("Done.");
        }

        private static void ImportFriends(MySqlCommand pMyCmd, SqlCommand pSqlCmd)
        {
            Console.Write("Importing Friends...");

            pMyCmd.CommandText = "SELECT COUNT(0) FROM wow_database_playerfriends";
            long total = (long)pMyCmd.ExecuteScalar();
            long count = 0;
            long percent = 0;

            pMyCmd.CommandText = "SELECT player_id,friend_id FROM wow_database_playerfriends ORDER BY player_id ASC";
            using (MySqlDataReader myDR = pMyCmd.ExecuteReader())
            {
                while (myDR.Read())
                {
                    pSqlCmd.CommandText = string.Format("INSERT INTO player_friend(player_id,friend_id) VALUES({0},{1})",
                                                        (uint)myDR["player_id"],
                                                        (uint)myDR["friend_id"]);
                    pSqlCmd.ExecuteNonQuery();

                    long newPercent = (long)(((float)(++count) / total) * 100);
                    if (newPercent != percent)
                    {
                        percent = newPercent;
                        Console.Title = string.Format("Status: {0}%", percent);
                    }
                }
            }

            pSqlCmd.Transaction.Commit();
            Console.WriteLine("Done.");
        }
        
        private static String EscapeAndQuote(String pValue)
        {
            return "'" + pValue.Replace("'", "''") + "'";
        }
    }
}
