﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace Curse.CurseClient.Common
{
    public class BaseSingleton<T> : INotifyPropertyChanged where T : class, new()
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        private static readonly T instance = new T();
        public static T Instance
        {
            get
            {
                return instance;
            }
        }
    }
}
