﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.MurmurHash;

namespace Curse.CurseClient.Common
{
    public static class CExceptionExtension
    {
        private const int SEED = 1;

        public static string CompleteDetails(this Exception ex)
        {
            string exceptionMessage = string.Empty;
            while (ex != null)
            {
                if (exceptionMessage != string.Empty)
                {
                    exceptionMessage += Environment.NewLine;
                }
                exceptionMessage += "Type: " + ex.GetType().ToString()
                    + Environment.NewLine + Environment.NewLine
                    + "Message: " + ex.Message
                    + Environment.NewLine + Environment.NewLine
                    + "Stack Trace: " + ex.StackTrace
                    + Environment.NewLine;

                ex = ex.InnerException;
            }
            return exceptionMessage;
        }

        public static UInt32 ComputeHash(this Exception ex)
        {
            string tokens = ex.GetType().Name + "-" + string.Join("-", ex.GetAllStackTraces());
            byte[] byteValues = Encoding.UTF8.GetBytes(tokens);
            return MurmurHash2.GetHashCode(ref byteValues, byteValues.Length, SEED);
        }

        public static List<Type> GetAllTypes(this Exception ex)
        {
            List<Type> types = new List<Type>();
            while (ex != null)
            {
                types.Add(ex.GetType());
                ex = ex.InnerException;
            }
            return types;
        }

        public static bool ContainsType(this Exception ex, Type t)
        {
            try
            {
                List<Type> types = ex.GetAllTypes();
                return types.Contains(t);
            }
            catch
            {
                return false;
            }
        }

        public static string[] GetAllStackTraces(this Exception ex)
        {
            List<string> stacks = new List<string>();
            while (ex != null)
            {
                stacks.Add(ex.StackTrace ?? string.Empty);
                ex = ex.InnerException;
            }
            return stacks.ToArray();
        }
    }
}
