﻿using System;
using NUnit.Framework;

namespace ServiceUnitTests.Attributes {
    #region Billing Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class BillingServiceCategoryAttribute : CategoryAttribute {
        public BillingServiceCategoryAttribute() : base("Billing Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class BillingObjectValidationAttribute : CategoryAttribute {
        public BillingObjectValidationAttribute() : base("Billing Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class BillingUnitTestsAttribute : CategoryAttribute {
        public BillingUnitTestsAttribute() : base("Billing Unit Tests") { }
    }
    #endregion

    #region Auth Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class AuthServiceCategoryAttribute : CategoryAttribute {
        public AuthServiceCategoryAttribute() : base("Authentication Service") { }
    }
    
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class AuthObjectValidationAttribute : CategoryAttribute {
        public AuthObjectValidationAttribute() : base("Auth Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class AuthUnitTestsAttribute : CategoryAttribute {
        public AuthUnitTestsAttribute() : base("Auth Unit Tests") { }
    }
    #endregion

    #region Client Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class ClientServiceCategoryAttribute : CategoryAttribute {
        public ClientServiceCategoryAttribute() : base("Client Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class ClientObjectValidationAttribute : CategoryAttribute {
        public ClientObjectValidationAttribute() : base("Client Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class ClientUnitTestsAttribute : CategoryAttribute {
        public ClientUnitTestsAttribute() : base("Client Unit Tests") { }
    }
    #endregion

    #region Curse Voice Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class VoiceServiceCategoryAttribute : CategoryAttribute
    {
        public VoiceServiceCategoryAttribute() : base("Curse Voice Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class VoiceObjectValidationAttribute : CategoryAttribute
    {
        public VoiceObjectValidationAttribute() : base("Voice Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class VoiceUnitTestsAttribute : CategoryAttribute
    {
        public VoiceUnitTestsAttribute() : base("Voice Unit Tests") { }
    }
    #endregion

    #region Azeroth Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class AzerothServiceCategoryAttribute : CategoryAttribute
    {
        public AzerothServiceCategoryAttribute() : base("Azeroth Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class AzerothObjectValidationAttribute : CategoryAttribute
    {
        public AzerothObjectValidationAttribute() : base("Azeroth Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class AzerothUnitTestsAttribute : CategoryAttribute
    {
        public AzerothUnitTestsAttribute() : base("Azeroth Unit Tests") { }
    }
    #endregion

    #region Game Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class GameServerServiceCategoryAttribute : CategoryAttribute
    {
        public GameServerServiceCategoryAttribute() : base("GameServer Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class GameServerObjectValidationAttribute : CategoryAttribute
    {
        public GameServerObjectValidationAttribute() : base("GameServer Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class GameServerUnitTestsAttribute : CategoryAttribute
    {
        public GameServerUnitTestsAttribute() : base("GameServer Unit Tests") { }
    }
    #endregion

    #region CommunityTracker Service
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class CommunityTrackerCategoryAttribute : CategoryAttribute
    {
        public CommunityTrackerCategoryAttribute() : base("CommunityTracker Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class CommunityTrackerObjectValidationAttribute : CategoryAttribute
    {
        public CommunityTrackerObjectValidationAttribute() : base("CommunityTracker Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class CommunityTrackerUnitTestsAttribute : CategoryAttribute
    {
        public CommunityTrackerUnitTestsAttribute() : base("CommunityTracker Unit Tests") { }
    }
    #endregion

    #region DownloadStatService
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class DownloadStatServiceCategoryAttribute : CategoryAttribute
    {
        public DownloadStatServiceCategoryAttribute() : base("DownloadStat Service") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class DownloadStatObjectValidationAttribute : CategoryAttribute
    {
        public DownloadStatObjectValidationAttribute() : base("DownloadStat Object Validation") { }
    }

    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false, Inherited = true)]
    public class DownloadStatUnitTestsAttribute : CategoryAttribute
    {
        public DownloadStatUnitTestsAttribute() : base("DownloadStat Unit Tests") { }
    }
    #endregion
}
