﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ServiceUnitTests.Extensions
{
    public static class NumberExtensions
    {
        public static byte[] ToByteArray(this int num)
        {
            byte[] rvalue = new byte[4];
            for (int i = 0; i <= 3; i++)
            {
                rvalue[i] = (byte)((num >> (i * 8)) & 0x000000FF);
            }
            return rvalue;
        }

        public static void AddInteger(this byte[] bytes, int offset, int num)
        {
            for (int i = 0; i <= 3; i++)
            {
                bytes[offset + i] = (byte)((num >> (i * 8)) & 0x000000FF);
            }
        }

        public static void AddString(this byte[] bytes, int offset, string value)
        {
            for (int i = 0; i < value.Length; i++)
            {
                bytes[offset + i] = (byte)value[i];
            }
        }
    }
}
