﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using System.Data.SqlClient;
using System.Configuration;
using ServiceUnitTests.AuthService;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.AzerothService;
using ServiceUnitTests.WowDbService;

namespace ServiceUnitTests.TestFixtures
{
    [TestFixture]
    [AzerothServiceCategory]
    public abstract class AzerothServiceTestFixture
    {
        AzerothServiceClient _azerothClient;
        public AzerothServiceClient AzerothClient
        {
            get { return _azerothClient; }
        }

        WowDbServiceClient _wowService;
        public WowDbServiceClient WowDbClient
        {
            get { return _wowService; }
        }

        string _dbConnectionString;
        public string DbConnectionString
        {
            get { return _dbConnectionString; }
        }

        public AzerothServiceTestFixture()
        {
            //_azerothClient = new AzerothServiceClient();
            _wowService = new WowDbServiceClient();
            _dbConnectionString = ConfigurationManager.ConnectionStrings["AzerothService"].ConnectionString;
        }
    }
}
