﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Curse.CurseClient.Common;
using Curse.AddOns;
using Curse.ClientService.Models;
using System.Configuration;
using System.Data.SqlClient;
using System.Data;
using ServiceUnitTests.Attributes;

namespace ServiceUnitTests.TestFixtures {
    [TestFixture]
    [ClientServiceCategory]
    abstract class ClientServiceTestFixture : BaseTestFixture {
        string _userName = "zusername";
        string _plainTextPassword = "password";
        string _encryptedPassword;
        CLoginResult _loginResult;

        public CServiceProxy Proxy { get { return CServiceProxy.Instance; } }
        public string EncryptedPassword { get { return _encryptedPassword; } }

        public Dictionary<int, CAddOn> Addons { get; set; }
        public Dictionary<int, List<int>> FileIdsByAddon { get; set; }
        public List<CSyncedAddon> SyncedAddons {
            get {
                if (Addons == null) {
                    return new List<CSyncedAddon>();
                }

                var syncedList = new List<CSyncedAddon>();
                foreach (var addon in Addons) {
                    var syncedAddon = new CSyncedAddon() {
                        AddonID = addon.Key,
                        FileID = FileIdsByAddon[addon.Key][0]
                    };

                    syncedList.Add(syncedAddon);
                }

                return syncedList;
            }
        }
        public List<CSyncTransaction> SyncTransactions {
            get {
                var transList = new List<CSyncTransaction>();
                foreach (var addon in SyncedAddons) {
                    var trans = new CSyncTransaction(ESyncTransactionType.Install, addon.AddonID, addon.FileID);
                    transList.Add(trans);
                }

                return transList;
            }
        }

        [SetUp]
        public void Init() {
            // Setup the service for a login
            CServiceProxy.Instance.Username = _userName;
            CServiceProxy.Instance.PlainTextPassword = _plainTextPassword;

            // in case we need this lets store it
            _encryptedPassword = CServiceProxy.Instance.EncryptedPassword;

            // Do the actual login
            _loginResult = CServiceProxy.Instance.LoginUser();
            PopulateAddonData();
        }

        [TearDown]
        public void ResetConnection() {
            if (!Proxy.IsConnected) {
                Proxy.Username = _userName;
                Proxy.PlainTextPassword = _plainTextPassword;
                Proxy.LoginUser();
            }
        }

        protected void PopulateAddonData() {
            Addons = new Dictionary<int, CAddOn>();

            using (var conn = new SqlConnection(RadonConnectionString)) {
                var cmd = new SqlCommand("SELECT TOP 10 p.ID FROM Project AS p WHERE p.DateSynced < @Date AND p.GameID = 1 AND p.Status = 1 AND p.Stage IN (2,4,5,7) AND (SELECT COUNT(0) FROM Radon.dbo.ProjectFile WHERE (Status = 1 OR (Status = 13 and IsAlternate = 1)) AND ProjectID = p.ID) > 0 ORDER BY p.ID DESC", conn);
                cmd.Parameters.Add("Date", SqlDbType.DateTime).Value = DateTime.Now.AddHours(-1);

                conn.Open();
                using (var reader = cmd.ExecuteReader()) {
                    while (reader.Read()) {
                        Addons.Add(reader.GetInt32(0), null);
                    }
                }

                FileIdsByAddon = new Dictionary<int, List<int>>();
                cmd.CommandText = string.Format("SELECT ID, ProjectID FROM ProjectFile WHERE (Status = 1 OR (Status = 13 AND IsAlternate = 1)) AND ProjectID in ({0})", string.Join(",", Addons.Keys.ToArray()));
                using (var reader = cmd.ExecuteReader()) {
                    while (reader.Read()) {
                        var addonId = (int)reader[1];
                        var fileId = (int)reader[0];

                        if (!FileIdsByAddon.ContainsKey(addonId)) {
                            FileIdsByAddon.Add(addonId, new List<int>());
                        }

                        FileIdsByAddon[addonId].Add(fileId);
                    }
                }
            }
        }
    }
}
