﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.CurseVoice;
using System.ServiceModel;

namespace ServiceUnitTests.TestFixtures
{
    [TestFixture]
    [VoiceServiceCategoryAttribute]
    abstract class CurseVoiceTestFixture : BaseTestFixture
    {
        VoiceClient _voiceClient;
        CurseVoiceServiceClient _client;
        public CurseVoiceServiceClient VoiceDuplexClient
        {
            get { return _client; }
        }

        CurseVoiceSoapServiceClient _soapClient;
        public CurseVoiceSoapServiceClient VoiceSoapClient
        {
            get { return _soapClient; }
        }

        [TestFixtureSetUp]
        public void Init()
        {
            _voiceClient = new VoiceClient();
            _client = new CurseVoiceServiceClient(_voiceClient.Context);
            _soapClient = new CurseVoiceSoapServiceClient();
        }

        [TestFixtureTearDown]
        public void TearDown()
        {
            _client.Close();
            _soapClient.Close();
        }
    }

    public class TransmitEventArgs : EventArgs
    {
        public TransmitEventArgs(VoiceTransmission data)
        {
            this.Data = data;
        }

        public VoiceTransmission Data { get; set; }
    }
    public class UserStateEventArgs : EventArgs
    {
        public UserStateEventArgs(VoiceUser data)
        {
            this.User = data;
        }
        public VoiceUser User { get; set; }
    }

    [CallbackBehavior(ConcurrencyMode = ConcurrencyMode.Reentrant, UseSynchronizationContext = false)]
    public class VoiceClient : ICurseVoiceServiceCallback
    {
        InstanceContext _context;
        public InstanceContext Context
        {
            get
            {
                if (_context == null)
                {
                    _context = new InstanceContext(this);
                }
                return _context;
            }
        }

        #region IVoiceClient Members

        public event EventHandler<TransmitEventArgs> OnTransmit;
        public void UserTransmit(VoiceTransmission vt)
        {
            if ((this.OnTransmit != null) && (vt != null))
            {
                this.OnTransmit(this, new TransmitEventArgs(vt));
            }
        }

        public event EventHandler<UserStateEventArgs> OnUserConnected;
        public event EventHandler<UserStateEventArgs> OnUserDisconnected;
        public event EventHandler<UserStateEventArgs> OnUserTransmission;

        public void UserConnected(VoiceUser user)
        {
            if ((this.OnUserConnected != null) && (user != null))
            {
                this.OnUserConnected(this, new UserStateEventArgs(user));
            }
        }
        public void UserDisconnected(VoiceUser user)
        {
            if ((this.OnUserDisconnected != null) && (user != null))
            {
                this.OnUserDisconnected(this, new UserStateEventArgs(user));
            }
        }

        public void UserTransmission(VoiceUser user)
        {
            if ((this.OnUserTransmission != null) && (user != null))
            {
                this.OnUserTransmission(this, new UserStateEventArgs(user));
            }
        }

        public void UserDisconnect()
        {
            Context.Close();
        }
        #endregion
    }
}
