﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using NUnit.Framework;
using System.ServiceModel;
using ServiceUnitTests.Common;
using System.Data.SqlClient;
using System.Data;
using System.Security.Cryptography;
using ServiceUnitTests.Attributes;

namespace ServiceUnitTests.UnitTests.AuthService {
    [AuthUnitTests]
    class LegacyWebMethods : AuthTestFixture {
        #region Static Variables
        string _emailAddress = "email@curse.com";
        string _emailActivationCode = @"Yn6iDq1AQSmFvFJAbZb/dMeGZP4=";
        #endregion

        #region Tests
        [Test]
        public void userIdExists() {
            var exisits = AuthClient.userIdExists(CurseSiteID, UserID);
            Assert.AreEqual(true, exisits);
        }

        [Test]
        public void userIdExistsWithInvalidUser() {
            var exisits = AuthClient.userIdExists(CurseSiteID, -1);
            Assert.AreEqual(false, exisits);
        }

        [Test]
        public void userIdExistsWithInvalidSite() {
            var exisits = AuthClient.userIdExists(-1, UserID);
            Assert.AreEqual(false, exisits);
        }

        [Test]
        public void getEmailActivationCode() {
            var hash = DoHashEmail(_emailAddress);
            var serviceHash = AuthClient.getEmailActivationCode(CurseSiteID, _emailAddress);
            Assert.AreEqual(hash, serviceHash);
        }

        [Test]
        [ExpectedException(typeof(ProtocolException))]
        public void getEmailActivationCodeWithInvalidSite() {
            var serviceHash = AuthClient.getEmailActivationCode(-1, _emailAddress);
            Assert.AreEqual(string.Empty, serviceHash);
        }

        [Test]
        public void initiateResetPassword() {
            Assert.Inconclusive("Not Implemented");
            //AuthClient.initiateResetPassword(CurseSiteID, _emailAddress, "www.curse.com");
        }

        [Test]
        public void activateEmailByCode() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        [ExpectedException(typeof(ProtocolException))]
        public void activateEmailByCodeWithInvalidCode() {
            AuthClient.activateEmailByCode("1_Yn6iDq1AQSmFvFJAbZb/dMeGZP4=");
        }

        [Test]
        public void activateEmailByCodeWithInvalidEmail() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void activateEmail() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void sendActivationEmailByAddress() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void sendActivationEmail() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void addUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void isLegacyUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void canRenameUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void renameUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void v2RenameUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void v2RenameUserDeclined() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void validateUserName() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getUserSubscriptions() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getSubscriptionStatus() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getPremiumLevel() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getUsernameFromUserId() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getUserEmailFromUserId() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getUserIdFromUsername() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getUserIdFromEmail() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void validateClientUserSession() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void validateClientUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void getUserProfile() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void validateInsecureClientUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void validateUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void validateUserSession() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void adminSetUserPassword() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void adminDeleteUser() {
            var userId = Utilities.CreateUser(CurseSiteID, RandomUsername, CurseEncPassword, FirstName, LastName, BirthDate, Gender, RandomEmailAddress);
            if (userId == 0) {
                Assert.Inconclusive("Failed to create the user");
            }// if there is no user id

            //Delete the user
            AuthClient.adminDeleteUser(CurseSiteID, userId);

            //Check all the tables to make sure there are things there
            using (var conn = new SqlConnection(AuthConnectionString)) {
                using (var cmd = new SqlCommand("select count(*) from useractivity where _uid = @userId", conn)) {
                    cmd.Parameters.Add("userId", SqlDbType.Int).Value = userId;

                    conn.Open();
                    // Test the user activity table                    
                    var count = (int)cmd.ExecuteScalar();
                    if (count > 0) {
                        Assert.Fail(string.Format("Found {0} records in the useractivity table. Expected 0", count));
                    }

                    // Check the user sessions table
                    cmd.CommandText = "select count(*) from usersessions where _uid = @userId";
                    count = (int)cmd.ExecuteScalar();
                    if (count > 0) {
                        Assert.Fail(string.Format("Found {0} records in the useractivity table. Expected 0", count));
                    }

                    // Check the user emails table
                    cmd.CommandText = "select count(*) from useremails where _uid = @userId";
                    count = (int)cmd.ExecuteScalar();
                    if (count > 0) {
                        Assert.Fail(string.Format("Found {0} records in the useremails table. Expected 0", count));
                    }

                    // Check the user legacy table
                    cmd.CommandText = "select count(*) from userlegacy where _uid = @userId";
                    count = (int)cmd.ExecuteScalar();
                    if (count > 0) {
                        Assert.Fail(string.Format("Found {0} records in the userlegacy table. Expected 0", count));
                    }

                    //Check the userprofiles table
                    cmd.CommandText = "select count(*) from userprofiles where _uid = @userId";
                    count = (int)cmd.ExecuteScalar();
                    if (count > 0) {
                        Assert.Fail(string.Format("Found {0} records in the userprofiles table. Expected 0", count));
                    }

                    //Check the user subscriptions table
                    //cmd.CommandText = "select count(*) from usersubscriptions where _uid = @userId";
                    //count = (int)cmd.ExecuteScalar();
                    //if (count > 0) {
                    //    Assert.Fail(string.Format("Found {0} records in the usersubscriptions table. Expected 0", count));
                    //}

                    //check the user table
                    cmd.CommandText = "select _username, _status from users where _uid = @userId";
                    using (var reader = cmd.ExecuteReader()) {
                        if (!reader.Read())
                            Assert.Fail("No rows were returned from the user table.");

                        //Check the username and status
                        var _username = (string)reader["_username"];
                        var _status = Int32.Parse(reader["_status"].ToString());

                        if (_username != string.Format("user_{0}", userId))
                            Assert.AreEqual(string.Format("user_{0}", userId), _username);

                        if (_status != 1) Assert.AreEqual(1, _status);
                    }//using the reader
                }//using the command object
            }//using conn
        }

        [Test]
        public void setUserPassword() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void setUserProfileInfo() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void signOutUser() {
            Assert.Inconclusive("Not Implemented");
        }

        [Test]
        public void updatePrimaryEmailAddress() {
            Assert.Inconclusive("Not Implemented");
        }
        #endregion

        #region Supporting Methods
        private string DoHashEmail(string emailaddress) {
            var _adminKey = UTF8Encoding.UTF8.GetBytes("333");
            byte[] mailbytes = Encoding.UTF8.GetBytes(emailaddress);
            SHA1 hasher = SHA1.Create();

            byte[] data = new byte[mailbytes.Length + _adminKey.Length];
            Buffer.BlockCopy(_adminKey, 0, data, 0, _adminKey.Length);
            Buffer.BlockCopy(mailbytes, 0, data, _adminKey.Length, mailbytes.Length);
            return Convert.ToBase64String(hasher.ComputeHash(data));
        }
        #endregion
    }
}
