﻿using System;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using NUnit.Framework;
using System.Net;
using System.IO;
using Curse;
using System.Text;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.Core;


namespace ServiceUnitTests.UnitTests.AzerothService
{
    [AzerothUnitTests]
    class BaseUnitTests : AzerothServiceTestFixture
    {
//        [Test]
//        public void AuthenticationlessUpload()
//        {

//        }

//        [Test]
//        public void UploadUpdate()
//        {
//            var client = new WebClient();
//            var result = client.UploadData(@"http://devazerothservice.curse.local/AzerothService.svc/UploadUpdate/
//        }

        [Test]
        public void CanUploadFile()
        {
            var response = WowDbClient.CanUploadFile(1);
            Assert.IsNotNull(response);
            Assert.IsNotNull(response.CanUpload);
            Assert.AreEqual(true, response.CanUpload);
        }

        [Test]
        public void UploadDbFile()
        {
            using (var fileStream = File.Open(@"c:\temp\questcache.wdb", FileMode.Open))
            {
                var memStream = new MemoryStream();
                byte[] buffer = new byte[fileStream.Length];
                fileStream.Read(buffer, 0, (int)fileStream.Length);
                memStream.Write(buffer, 0, buffer.Length);
                memStream.Position = 0;

                var zipStream = CreateToMemoryStream(memStream, "questcache.wdb");
                WowDbClient.UploadDbFile("items.wdb", 100, zipStream);
            }         
        }

        MemoryStream CreateToMemoryStream(MemoryStream memStreamIn, string zipEntryName)
        {

            MemoryStream outputMemStream = new MemoryStream();
            ZipOutputStream zipStream = new ZipOutputStream(outputMemStream);

            zipStream.SetLevel(3); //0-9, 9 being the highest level of compression

            ZipEntry newEntry = new ZipEntry(zipEntryName);
            newEntry.DateTime = DateTime.Now;

            zipStream.PutNextEntry(newEntry);

            StreamUtils.Copy(memStreamIn, zipStream, new byte[4096]);
            zipStream.CloseEntry();

            zipStream.IsStreamOwner = false;    // False stops the Close also Closing the underlying stream.
            zipStream.Close();          // Must finish the ZipOutputStream before using outputMemStream.

            outputMemStream.Position = 0;
            return outputMemStream;
        }
    }
}
