﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using NUnit.Framework;
using Curse.CurseClient.Common.ClientService;
using System.IO;
using System.ServiceModel;
using Curse.ClientService.Models;
using System.Net;

namespace ServiceUnitTests.UnitTests.ClientService {
    [ClientUnitTests]
    class AdminNegativeTests : ClientServiceTestFixture {
        [Test(Description = "Call GetAddonDump without an admin account.")]
        [ExpectedException(typeof(FaultException))]
        public void GetAddonDumpNegative() {
            var result = Proxy.TryCall<Stream>(delegate(CClientServiceClient svc) {
                return svc.GetAddOnDump(0);
            });
        }

        [Test(Description = "Call GetClientServiceStatistics without an admin account.")]
        [ExpectedException(typeof(FaultException))]
        public void GetClientServiceStatisticsNegative() {
            var result = Proxy.TryCall<CServiceResponse<ServiceStatistics>>(delegate(CClientServiceClient svc) {
                return svc.GetServiceStatistics();
            });
        }

        [Test(Description = "Call ResetAllAddonCache without an admin account.")]
        [ExpectedException(typeof(FaultException))]
        public void ResetAllAddonCacheNegative() {
            var result = Proxy.TryCall<string>(delegate(CClientServiceClient svc) {
                return svc.ResetAllAddonCache();
            });
        }

        [Test(Description = "Call ResetSingleAddonCache without an admin account.")]
        [ExpectedException(typeof(FaultException))]
        public void ResetSingleAddonCacheNegative() {
            var result = Proxy.TryCall<string>(delegate(CClientServiceClient svc) {
                return svc.ResetSingleAddonCache(0);
            });
        }

        #region Cannot find anything which calls these functions
        [Test(Description = "Call GetAddonInstallCounts without an admin account.")]
        [ExpectedException(typeof(WebException))]
        public void GetAddonInstallCountsNegative() {
            var request = (HttpWebRequest)WebRequest.Create("http://clientservice.curse.com/CClientService.svc/GetAddonInstallCounts");
            var response = request.GetResponse();
            var contentType = response.Headers["Content-Type"];
            Assert.AreEqual(@"application/x-zip-compressed", contentType);
        }
        #endregion
    }
}
