﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.TestFixtures;
using NUnit.Framework;
using Curse.ClientService.Models;
using Curse.CurseClient.Common.ClientService;
using System.Data.SqlClient;

namespace ServiceUnitTests.UnitTests.ClientService {
    [ClientUnitTests]
    class CampaignTests : ClientServiceTestFixture {

        [Test]
        public void GetActiveCampaign() {
            var result = Proxy.TryCall<CCampaign>(delegate(CClientServiceClient svc) {
                return svc.GetActiveCampaign();
            });

            using (var conn = new SqlConnection(ClientServiceConnectionString)) {
                var cmd = new SqlCommand("SELECT * FROM Campaign WHERE ID IN (SELECT CampaignID FROM CampaignRegion WHERE RegionID = 1) AND EndDate > GetDate()", conn);

                conn.Open();
                using (var reader = cmd.ExecuteReader()) {
                    if (!reader.HasRows) {
                        Assert.IsNull(result);
                        return;
                    }

                    reader.Read();
                    if (result != null) {
                        Assert.AreEqual((string)reader["Name"], result.Name);
                    }
                    else Assert.Fail("Service returned no active campaingns.");
                }
            }
        }

        [Test]
        public void GetThemePackHash() {
            var result = Proxy.TryCall<string>(delegate(CClientServiceClient svc) {
                return svc.GetThemePackHash();
            });

            if (result != null) {
                Assert.AreNotEqual(string.Empty, result);
            }
            else Assert.IsNotNull(result);
        }
    }
}
