﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using NUnit.Framework;
using System.Data.SqlClient;
using System.Data;
using ServiceUnitTests.GameServerService;
using System.Diagnostics;

namespace ServiceUnitTests.UnitTests.GameServerService
{
    [GameServerUnitTestsAttribute]
    class GameServerUnitTests : GameServerTestFixture
    {

        [SetUp]
        public void Init()
        {
            PopulateGeoData();
        }
        
        List<CountryIPRange> _countryIpRanges = new List<CountryIPRange>();
        public void PopulateGeoData()
        {
            List<CountryIPRange> countryIPRanges = new List<CountryIPRange>();
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("SELECT * FROM CountryIpRange ORDER BY CountryCode", conn);

                conn.Open();
                using (var reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        countryIPRanges.Add(new CountryIPRange(reader));
                    }
                }
                CountryIPRange.BuildRanges(countryIPRanges);
            }

            _countryIpRanges = countryIPRanges;
        }
        
        [Test]
        public void SetVerificationToken()
        {
            byte[] address = new byte[16];
            int port = 0;
            
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("SELECT TOP(1) IPAddress, Port FROM GameServer WHERE GameServerDataSourceID = (SELECT ID FROM GameServerDataSource WHERE Name = 'Minecraft')", conn);

                conn.Open();
                using (var reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        reader.GetBytes(reader.GetOrdinal("IPAddress"), 0, address, 0, 16);
                        port = reader.GetInt32(reader.GetOrdinal("Port"));

                        var result = Client.SetServerVerification("Minecraft", address, port, Guid.NewGuid(), EVerificationStatus.Pending);
                        Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
                    }
                    else
                    {
                        Assert.Inconclusive("Unable to pull an IP and Port from the DB.");
                    }
                }
            }
        }

        [Test]
        public void UpdateGameServerCountry()
        {
            byte[] address;
            int port = 0;

            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("SELECT TOP(1) IPAddress, Port FROM GameServer WHERE GameServerDataSourceID = (SELECT ID FROM GameServerDataSource WHERE Name = 'Minecraft')", conn);

                conn.Open();
                using (var reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        address = (byte[])reader.GetValue(reader.GetOrdinal("IPAddress"));
                        port = reader.GetInt32(reader.GetOrdinal("Port"));

                        var result = Client.UpdateGameServerCountry("Minecraft", address, port, "US");
                        Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
                    }
                    else
                    {
                        Assert.Inconclusive("Unable to pull an IP and Port from the DB.");
                    }
                }
            }
        }

        [Test]
        public void TestGeoCoding()
        {
            // GeoCoding
            //var countryIpRange = CountryIPRange.GetRange((gameServer.IPAddress.Length > 4) ? BitConverter.ToInt64(gameServer.IPAddress, 0) : BitConverter.ToInt32(gameServer.IPAddress, 0));
            //if (countryIpRange != null)
            //{
            //    gameServer.CountryCode = countryIpRange.CountryCode;
            //}
            //else { gameServer.CountryCode = "Unknown"; }
        }

        [Test]
        public void GetAllGameReleases()
        {
            var response = Client.GetAllGameReleases();
        }

        [Test]
        public void GetAllGameReleasesByGameID()
        {
        }

        [Test]
        public void UpdateGameReleaseNotes()
        {

        }
    }

    public class CountryIPRange
    {
        public Int64 Start { get; set; }
        public Int64 End { get; set; }
        public string CountryCode { get; set; }

        private static Dictionary<Int64, CountryIPRange> _values;
        private static Int64[] _binarySearchIndex;

        public CountryIPRange(SqlDataReader reader)
        {
            CountryCode = (string)reader["CountryCode"];
            Start = (Int64)reader["IPRangeStart"];
            End = (Int64)reader["IPRangeEnd"];
        }

        public static void BuildRanges(IEnumerable<CountryIPRange> ranges)
        {
            _values = new Dictionary<Int64, CountryIPRange>();

            foreach (var item in ranges)
            {
                _values[item.Start] = item;
            }

            _binarySearchIndex = _values.Keys.ToArray();

            Array.Sort(_binarySearchIndex);
        }

        public static CountryIPRange GetRange(Int64 value)
        {
            DateTime startDateTime = DateTime.Now;

            int searchIndex = Array.BinarySearch(_binarySearchIndex, value);
            if (searchIndex < 0)
                searchIndex = ~searchIndex - 1;
            if (searchIndex < 0)
                return null;
            CountryIPRange proposedRange = _values[_binarySearchIndex[searchIndex]];

            Debug.WriteLine("Total milliseconds: " + (DateTime.Now - startDateTime).TotalMilliseconds.ToString("0") + "ms");

            if (proposedRange.End >= value)
            {
                return proposedRange;
            }
            else
            {
                return null;
            }
        }
    }
}
