﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.Extensions;
using ServiceUnitTests.CurseVoice;
using NUnit.Framework;
using System.Net.Sockets;
using System.Threading;
using System.IO;
using System.Net;
using ServiceUnitTests.Common;
using System.Xml;

namespace ServiceUnitTests.UnitTests.VoiceService
{
    [VoiceUnitTests]
    class MacVoiceTests : CurseVoiceTestFixture
    {
        TcpClient _tcpClient;
        string _username = "MacVoiceTest";
        
        [TestFixtureSetUp]
        public new void Init()
        {
            base.Init();

            var response = MacAuthenticate(_username, "TEST");
            if (string.IsNullOrEmpty(response))
            {
                Assert.Fail("MacAuthenticate Soap call failed");
            }

            _tcpClient = new TcpClient("devcursevoice.curse.local", 6943);
            Assert.AreEqual(true, _tcpClient.Connected, "Failed to connect via Tcp");

            // Make the final connection
            SendAuthenticationMessage(response);
        }

        [TestFixtureTearDown]
        public new void TearDown()
        {
            // try to close the tcpConnection
            if (_tcpClient != null)
            {
                // Disconnected
                SendDisconnectMessage();
                _tcpClient.Close();
            }

            base.TearDown();
        }
        
        [Test]
        public void Connected()
        {
            if (_tcpClient == null)
            {
                Assert.Inconclusive("No actice Tcp Connection.");
            }
            Assert.AreEqual(true, _tcpClient.Connected, "Failed to connect via Tcp");
        }

        [Test(Description = "This will be a SOAP Call")]
        public void GetConnectedUsers()
        {
            var users = GetConnectedUsers(string.Empty);
            Assert.IsNotNull(users);

            // I should have at least one in the list
            //if (_tcpClient != null && users.Count > 0)
            //{
            //    var user = users.FirstOrDefault(p => p.Username == _username);
            //    Assert.IsNotNull(user);
            //}
            //else Assert.Inconclusive("No users returned.");
        }

        [Test(Description = "This will be a SOAP Call")]
        public void MacAuthenticate()
        {
            var metaUsername = Guid.NewGuid().ToString();
            string respose = MacAuthenticate(metaUsername, "TEST");
            Assert.AreEqual(metaUsername, respose);

            // TODO: Make the completed connection here
        }

        [Test]
        public void Disconnect()
        {
            //if (_tcpClient != null)
            //{
            //    SendDisconnectMessage();
            //}
            //else Assert.Inconclusive("No connection to disconnect.");
        }

        #region Supporing Methods
        public string MacAuthenticate(string username, string sessionId)
        {
            try
            {
                var requestUrl = string.Format("http://devcursevoice.curse.local/CurseVoiceService.svc/Soap11/MacAuthenticate?username={0}&sessionId={1}", username, sessionId);
                var request = (HttpWebRequest)WebRequest.Create(requestUrl);
                WebResponse response = request.GetResponse();
                Assert.IsNotNull(response);

                Stream responseStream = response.GetResponseStream();
                Assert.IsNotNull(responseStream);

                var responseString = new StreamReader(responseStream).ReadToEnd();
                var doc = new XmlDocument();
                doc.LoadXml(responseString);

                return doc.InnerText;
            }
            catch (Exception)
            {
                return null;
            }
        }
        public List<VoiceUser> GetConnectedUsers(string apiKey)
        {
            var voiceUsers = new List<VoiceUser>();
            
            var requestUrl = string.Format("http://devcursevoice.curse.local/CurseVoiceService.svc/Soap11/GetConnectedUsers?apiKey={0}", apiKey);
            var request = (HttpWebRequest)WebRequest.Create(requestUrl);
            WebResponse response = request.GetResponse();
            Assert.IsNotNull(response);

            Stream responseStream = response.GetResponseStream();
            Assert.IsNotNull(responseStream);

            var responseString = new StreamReader(responseStream).ReadToEnd();
            var doc = new XmlDocument();
            doc.LoadXml(responseString);
            
            XmlNodeList userNodes = doc.GetElementsByTagName("VoiceUser");
            foreach (XmlNode userNode in userNodes)
            {
                var voiceUser = new VoiceUser
                {
                    ID = Guid.Parse(userNode.SelectSingleNode("*//ID").InnerText),
                    Username = userNode.SelectSingleNode("*//Username").InnerText,
                    IsTalking = bool.Parse(userNode.SelectSingleNode("*//IsTalking").InnerText)
                };

                voiceUsers.Add(voiceUser);
            }

            return voiceUsers;
        }

        public void SendAuthenticationMessage(string username)
        {
            NetworkStream stream = _tcpClient.GetStream();
            Assert.IsNotNull(stream);

            var builder = new MessageBuilder();
            builder.Append((byte)0x01); // Authenitcate message identifier
            builder.Append(Guid.NewGuid().ToString()); //message id
            builder.Append(username); // username (will be GUID later)

            byte[] message = builder.ToArray();
            stream.Write(message, 0, message.Length);
        }
        public void SendDisconnectMessage()
        {
            NetworkStream stream = _tcpClient.GetStream();
            Assert.IsNotNull(stream);

            var builder = new MessageBuilder();
            builder.Append((byte)0x06); // Authenitcate message identifier
            builder.Append(Guid.NewGuid().ToString()); //message id
            
            byte[] message = builder.ToArray();
            stream.Write(message, 0, message.Length);
        }
        #endregion
    }
}
