﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Configuration;

namespace VoiceSubscriptionMiner.Models
{
	class AccountEntitlementData
	{
		public uint ServiceID { get; set; }
		public string EntitlementID { get; set; }
		public int MaxClients { get; set; }
		public DateTime DateExpires { get; set; }
		public bool IsActive
		{
			get
			{
				return (DateExpires > DateTime.UtcNow);
			}
		}

		public AccountEntitlementData(SqlDataReader reader)
		{
			ServiceID = (uint)reader.GetInt64(reader.GetOrdinal("ServiceID"));
			EntitlementID = reader.GetString(reader.GetOrdinal("EntitlementID"));
			MaxClients = reader.GetInt32(reader.GetOrdinal("MaxClients"));
			DateExpires = reader.GetDateTime(reader.GetOrdinal("DateExpires"));
		}

		#region static Methods
		public static List<AccountEntitlementData> GetAllEntitlements()
		{
			List<AccountEntitlementData> entitlements = new List<AccountEntitlementData>();
			var query = "SELECT " +
							"VoiceService.ServiceID, " +
							"Entitlements.EntitlementID, " +
							"CONVERT(INT, SUBSTRING(Entitlements.EntitlementID, 3, LEN(Entitlements.EntitlementID) - 2)) AS MaxClients, " +
							"Entitlements.DateExpires " +
						"FROM BillingService.dbo.AccountEntitlement AS Entitlements " +
							"INNER JOIN BillingService.dbo.AccountVoiceClient AS VoiceClient ON VoiceClient.AccountID = Entitlements.AccountID " +
							"INNER JOIN BillingService.dbo.AccountVoiceService AS VoiceService ON VoiceClient.ID = VoiceService.AccountVoiceClientID " +
						"WHERE Entitlements.EntitlementID IN ('VH10', 'VH25', 'VH50', 'VH100')";

			using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["BillingService"].ConnectionString))
			{
				var cmd = new SqlCommand(query, conn);

				conn.Open();
				using (var reader = cmd.ExecuteReader())
				{
					while (reader.Read())
					{
						var entitlement = new AccountEntitlementData(reader);
						entitlements.Add(entitlement);
					}
				}
			}

			return entitlements;
		}
		public static List<AccountEntitlementData> GetUpdatedEntitlements(DateTime lastRuntime)
		{
			List<AccountEntitlementData> entitlements = new List<AccountEntitlementData>();
			var query = @"
				SELECT 
					VoiceService.ServiceID, 
					Entitlements.EntitlementID, 
					CONVERT(INT, SUBSTRING(Entitlements.EntitlementID, 3, LEN(Entitlements.EntitlementID) - 2)) AS MaxClients, 
					Entitlements.DateExpires 
				FROM BillingService.dbo.AccountEntitlement AS Entitlements 
					INNER JOIN BillingService.dbo.AccountVoiceClient AS VoiceClient ON VoiceClient.AccountID = Entitlements.AccountID 
					INNER JOIN BillingService.dbo.AccountVoiceService AS VoiceService ON VoiceClient.ID = VoiceService.AccountVoiceClientID 
				WHERE Entitlements.EntitlementID IN ('VH10', 'VH25', 'VH50', 'VH100') 
					AND DateUpdated > @lastRuntime 
				order by VoiceService.ServiceID";

			using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["BillingService"].ConnectionString))
			{
				var cmd = new SqlCommand(query, conn);
				cmd.Parameters.Add("lastRuntime", System.Data.SqlDbType.DateTime).Value = lastRuntime;

				conn.Open();
				using (var reader = cmd.ExecuteReader())
				{
					while (reader.Read())
					{
						var entitlement = new AccountEntitlementData(reader);
						entitlements.Add(entitlement);
					}
				}
			}
			if (entitlements.Count == 0)
			{
				Curse.Logger.Log("Got {0} elements back from Database, restart", Curse.ELogLevel.Error, entitlements.Count);
			}
			return entitlements;
		}
		#endregion
	}
}
