﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using VoiceSubscriptionMiner.LightSpeed.Ventrilo;
using VoiceSubscriptionMiner.Extensions;

namespace VoiceSubscriptionMiner.Models
{
	public enum VentriloServiceAdminStatus
	{
		Active,
		Suspended
	}
	public enum VentriloServiceServerStatus
	{
		Uninstalled,
		Offline,
		Online
	}
	public enum VentriloServiceAction
	{
		Start,
		Stop,
		Restart,
		Install,
		Uninstall,
		UpdateMaxClientCount
	}

	public class VentriloServiceInformation
	{
		public VentriloServiceInformation(serviceInfo serviceInfo)
		{
			AdminPassword = serviceInfo.serverAdminPassword;
			AdminStatus = serviceInfo.adminStatus.ToEnum<VentriloServiceAdminStatus>().Value;
			MaxClients = (int)serviceInfo.slots;
			Name = serviceInfo.serverName;
			ServiceID = serviceInfo.serviceId;
			ServerStatus = serviceInfo.serverStatus.ToEnum<VentriloServiceServerStatus>().Value;
			IP = IPAddress.Parse(serviceInfo.ipAddress);
			Port = (int)serviceInfo.ipPort;
			LocationID = serviceInfo.locationId;
		}

		public string AdminPassword { get; private set; }

		public VentriloServiceAdminStatus AdminStatus { get; private set; }

		public int MaxClients { get; private set; }

		public string Name { get; private set; }

		public IPAddress IP { get; private set; }

		public int Port { get; private set; }

		public uint ServiceID { get; private set; }

		public uint LocationID { get; private set; }

		public VentriloServiceServerStatus ServerStatus { get; private set; }

		#region static methods

		#endregion
	}
}
