﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VoiceSubscriptionMiner.Models
{
    class VoiceSubInvoiceDataCollection : List<VoiceSubInvoiceData>
    {
        #region Properties
        public VoiceSubInvoiceData this[long serviceId]
        {
            get
            {
                return this.FirstOrDefault(p => p.ServiceID == serviceId);
            }
        }
        public string[] ServiceIDs
        {
            get
            {
                var serviceIds = new List<string>();
                foreach (VoiceSubInvoiceData voiceSub in this)
                {
                    serviceIds.Add(voiceSub.ServiceID.ToString());
                }
                return serviceIds.ToArray();
            }
        }
        #endregion

        public VoiceSubInvoiceDataCollection() : base() { }

        public bool ContainsServiceID(long serviceId)
        {
            return this.Exists(p => p.ServiceID == serviceId);
        }
    }
}
