﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VoiceSubscriptionMiner.LightSpeed.Ventrilo;
using VoiceSubscriptionMiner.Models;

namespace VoiceSubscriptionMiner.Services
{
	class VentrilloService
	{
		private RequestCredentialsType Credentials
		{
			get
			{
#if DEBUG
                return new RequestCredentialsType()
                {
                    username = "cursedev",
                    apiKey = "C2E4EC98-DFFFBD51-D406C590-DA3C6DAC-69CA390B"
                };
#else
				return new RequestCredentialsType()
				{
					username = "curse",
					apiKey = "CEF955EA-30F41A21-30DDDAD9-A26A932C-B0C78EB6"
				};
#endif
			}
		}

		static VentrilloService _instance;
		public static VentrilloService Instance
		{
			get
			{
				if (_instance == null)
				{
					_instance = new VentrilloService();
				}

				return _instance;
			}
		}

		private RSAPIVTInterfaceClient _client;
		private RSAPIVTInterfaceClient Client
		{
			get
			{
				if (_client == null)
				{
					_client = new RSAPIVTInterfaceClient();
				}
				return _client;
			}
		}

		public VentrilloService()
		{
		}

		public VentriloServiceInformation GetVoiceSubStatus(uint serviceId)
		{
			var result = Client.serviceInformation(Credentials, new serviceIdOnlyType { serviceId = serviceId });
			return new VentriloServiceInformation(result);
		}

		public bool CancelService(uint serviceId, VentriloServiceAction action)
		{
			return Client.serviceControl(Credentials, new serviceControlRequestType { serviceId = serviceId, action = action.ToString().ToLower() });
		}

		public bool UpdateSlotCount(uint serviceId, int slots)
		{
			return Client.configUpdateSlotCount(Credentials, new configUpdateSlotCountRequestType { serviceId = serviceId, slots = (uint)slots });
		}

		public bool CancelServiceTestExc(uint serviceId, VentriloServiceAction action)
		{
			throw new System.ServiceModel.FaultException("Just a test no need to panic or picnic, CancelService");
			return false;
		}

		public bool UpdateSlotCountTestExc(uint serviceId, int slots)
		{
			throw new System.ServiceModel.FaultException("Just a test no need to panic or picnic, UpdateSlotCount");
			return false;
		}
	}
}
