﻿using Curse;
using Curse.WAR;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Xml.Serialization;

namespace WARDataService
{
    /**
     * Handles loading a complex configuration format into exact in-memory format for quick access
     *
     * @author Michael Comperda
     */
    public sealed class Config
    {
     
        public static Int32 LocaleCount = Enum.GetNames(typeof(ELocale)).Length;
        public static Config Instance = null;

        /**
         * Handles loading the config file as defined in the web.config
         * 
         * @return  true if the configuration file was loaded, false otherwise
         */
        public static Boolean Load()
        {
            String path = ConfigurationManager.AppSettings["ConfigFile"];
            if (!File.Exists(path))
            {
                return false;
            }
            using (FileStream stream = new FileStream(path, FileMode.Open, FileAccess.Read))
            {
                XmlSerializer serializer = new XmlSerializer(typeof(Config));
                Instance = (Config)serializer.Deserialize(stream);
            }
            return true;
        }

        /**
         * Public member variables for XML deserialization
         */
        public ELogLevel LogLevel;
        public String LogPath;        
        public String DumpPath;
        public String DLLFile;
        public String AdminKey;
        public String ClientKey;
        public String AuthenticationService;
        public Int32 AuthenticationId;
        public String AuthenticationKey;
        public Int32 SessionExpiration;
        public Int32[] Versions;       
        public String ConnectionString;
        public Int32 MaxQueuedUpdates;
        public Int32[] Trusted;
        public Int32 RateLimit;
        public String[] Whitelist;       
        public Int32 SkipConfirmationForVersion;
        public Int32 MinConfirmations;
        public Int64 MinProfilerVersion;
        public Int32 NpcExpiration;
        public Int32 SpellExpiration;
        public Int32 ItemExpiration;        
        public Int32 QuestExpiration;
        public Int32 GuildExpiration;
        public Int32 MerchandiseExpiration;
        public String[] SupportedLocales;
    }
}