﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
namespace WARDataService
{
    public static partial class DBAdvances
    {
        //private const Byte NUM_BONUSES = 10;
        //private const Byte NUM_CRAFTING_BONUSES = 25;

        private static HashSet<CustomKey> sKnownAdvances =
            new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sHistory =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());

        private static String sUpdateQuery = null;

        private static Dictionary<string, string> sUpdateCustomColumns = new Dictionary<string, string>();

        private static String[] sUpdateIgnoredColumns = { "id", "version_id", "posted", "posted_id" };

        private static DataTable sTableSchema = null;

        public static void Initialize()
        {
            sKnownAdvances.Clear();
            sHistory.Clear();

            foreach (Int32 version in Config.Instance.Versions)
            {
                DB.PopulateId(sKnownAdvances, "advance", version);
            }
            DB.LoadSchema(ref sTableSchema, "advance");

            sUpdateCustomColumns.Add("careers", "advance.careers=advance.careers|tmp.careers");

            sUpdateQuery = "update advance set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sTableSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM advance,#advance tmp" +
                " WHERE advance.id=tmp.id AND advance.version_id=tmp.version_id;";

        }

        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.Advances.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtInsert = sTableSchema.Clone();
            DataTable dtUpdate = sTableSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();

            SqlBulkCopy bulkInsert = new SqlBulkCopy(pConn,
                                                    SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                    null);

            SqlBulkCopy bulkUpdate = new SqlBulkCopy(pConn,
                                                     SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                     null);

            bulkInsert.BatchSize = 5000;
            bulkUpdate.BatchSize = 5000;
            bulkInsert.DestinationTableName = "advance";
            bulkUpdate.DestinationTableName = "#advance";


            bool isNewRow = false;
            foreach (Advance advance in pUpdate.Advances)
            {
                if (!DB.ReadyForDB(sHistory,
                                sConfirmations,
                                advance.Id,
                                Config.Instance.SpellExpiration,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                (ELocale)pUpdate.Language,
                                pUpdate.IsTrustedUser))
                {
                    continue;
                }

                key = new CustomKey(pUpdate.ClientVersion.Value,
                                    advance.Id);
                isNewRow = !sKnownAdvances.Contains(key);

                if (isNewRow)
                {
                    dr = dtInsert.NewRow();
                }
                else
                {
                    dr = dtUpdate.NewRow();
                }

                dr["category"] = advance.Category;
                dr["ability_id"] = advance.AbilityId;
                dr["id"] = advance.Id;
                dr["version_id"] = pUpdate.ClientVersion.Value;
                dr["name_" + locale] = advance.Name.Value;
                dr["description_" + locale] = advance.Description;
                dr["icon_id"] = advance.Id;
                dr["type_id"] = advance.Type;
                dr["required_rank"] = advance.RequiredRank;
                dr["required_renown"] = advance.RequiredRenown;
                dr["package_id"] = advance.PackageId;
                dr["required_category_points"] = advance.RequiredCategoryPoints;
                dr["value"] = advance.Value;
                dr["tier"] = advance.Tier;
                dr["required_points"] = advance.RequiredPoints;
                dr["max_purchase_count"] = advance.MaxPurchaseCount;
                dr["career_id"] = advance.CareerId;
                dr["careers"] = Utility.GetBitValue(advance.CareerId);
                
                // Meta Data
                dr["updated_id"] = pUpdate.UserId;
                dr["posted_id"] = pUpdate.UserId;
                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;

                if (isNewRow)
                {
                    dtInsert.Rows.Add(dr);
                    sKnownAdvances.Add(key);
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }

            }

            // New Items
            if (dtInsert.Rows.Count > 0)
            {
                bulkInsert.WriteToServer(dtInsert);
                bulkInsert.Close();
            }

            // Item Updates
            if (dtUpdate.Rows.Count > 0)
            {
                SqlCommand cmd = pConn.CreateCommand();
                cmd.CommandText = "SELECT TOP 0 * INTO #advance FROM advance;";
                cmd.ExecuteNonQuery();                
                bulkUpdate.WriteToServer(dtUpdate);
                bulkUpdate.Close();
                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #advance;";
                cmd.ExecuteNonQuery();
            }
        }

    }

}