﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class SkillLineDBC
    {
        private static Dictionary<CustomKey, List<UInt16>> sSkillLines =
            new Dictionary<CustomKey, List<UInt16>>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("SkillLineDBC Loading");

            sSkillLines.Clear();
            if (!Array.TrueForAll<Config.SkillLineDBCSchema>(Config.Instance.SkillLineDBCSchemas,
                                                             s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.SkillLineDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}SkillLine.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 lineId;
                Int32 lineNameOffset;
                String lineName;
                CustomKey key;
                List<UInt16> value;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.Id, out lineId) &&
                        dbcReader.ReadField(pSchema.Name, out lineNameOffset) &&
                        dbcReader.ReadString(lineNameOffset, out lineName) &&
                        lineName.Length > 0)
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            lineName);

                        if (!sSkillLines.TryGetValue(key, out value))
                        {
                            value = new List<UInt16>();
                            sSkillLines[key] = value;
                        }
                        value.Add(Convert.ToUInt16(lineId));
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean LookupId(UInt16 pVersion,
                                       ELocale pLocale,
                                       String pName,
                                       Byte pRaceId,
                                       Byte pClassId,
                                       out UInt16 pId)
        {
            pId = 0;
            List<UInt16> lines;
            Boolean ok = sSkillLines.TryGetValue(new CustomKey(pVersion,
                                                               pLocale,
                                                               pName),
                                                 out lines);
            if (ok)
            {
                foreach (UInt16 lineId in lines)
                {
                    if (SkillRaceClassInfoDBC.RaceExists(pVersion,
                                                         pLocale,
                                                         lineId,
                                                         pRaceId) &&
                        SkillRaceClassInfoDBC.ClassExists(pVersion,
                                                          pLocale,
                                                          lineId,
                                                          pClassId))
                    {
                        pId = lineId;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}
