﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class SkillRaceClassInfoDBC
    {
        private static Dictionary<CustomKey, Int32> sRaceInfo =
            new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());
        private static Dictionary<CustomKey, Int32> sClassInfo =
            new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("SkillRaceClassInfoDBC Loading");

            sRaceInfo.Clear();
            sClassInfo.Clear();
            if (!Array.TrueForAll<Config.SkillRaceClassInfoDBCSchema>(Config.Instance.SkillRaceClassInfoDBCSchemas,
                                                                      s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.SkillRaceClassInfoDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}SkillRaceClassInfo.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 skillLineId;
                Int32 requiredRaces;
                Int32 requiredClasses;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.SkillLineId, out skillLineId) &&
                        dbcReader.ReadField(pSchema.RequiredRace, out requiredRaces) &&
                        dbcReader.ReadField(pSchema.RequiredClass, out requiredClasses))
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            skillLineId);
                        if (!sRaceInfo.ContainsKey(key))
                        {
                            sRaceInfo[key] = requiredRaces;
                        }
                        else
                        {
                            sRaceInfo[key] |= requiredRaces;
                        }
                        if (!sClassInfo.ContainsKey(key))
                        {
                            sClassInfo[key] = requiredClasses;
                        }
                        else
                        {
                            sClassInfo[key] |= requiredClasses;
                        }
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean RaceExists(UInt16 pVersion,
                                         ELocale pLocale,
                                         UInt16 pLineId,
                                         Byte pRaceId)
        {
            Int32 mask;
            if (sRaceInfo.TryGetValue(new CustomKey(pVersion,
                                                    pLocale,
                                                    pLineId),
                                      out mask))
            {
                if (mask < 0)
                {
                    return true;
                }

                for (Int32 index = 1;
                     index <= ChrRacesDBC.MaxRace;
                     ++index)
                {
                    if (index == pRaceId && (mask & 0x01) != 0)
                        return true;
                    mask >>= 1;
                }
            }
            return false;
        }

        public static Boolean ClassExists(UInt16 pVersion,
                                          ELocale pLocale,
                                          UInt16 pLineId,
                                          Byte pClassId)
        {
            Int32 mask;
            if (sClassInfo.TryGetValue(new CustomKey(pVersion,
                                                     pLocale,
                                                     pLineId),
                                       out mask))
            {
                if (mask < 0)
                {
                    return true;
                }

                for (Int32 index = 1;
                     index <= ChrClassesDBC.MaxClass;
                     ++index)
                {
                    if (index == pClassId && (mask & 0x01) != 0)
                        return true;
                    mask >>= 1;
                }
            }
            return false;
        }
    }
}
