﻿using Curse;
using Curse.WoW;
using Curse.WoW.WDB;
using WoWDataCenter.DBC;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace WoWDataCenter
{
    public static partial class DB
    {
        public static void LoadGameObjectSchemaOrdinals()
        {
            sGameObjectOrdinalId = sGameObjectSchema.Columns.IndexOf("id");
            sGameObjectOrdinalVersionId = sGameObjectSchema.Columns.IndexOf("version_id");
            sGameObjectOrdinalType = sGameObjectSchema.Columns.IndexOf("type");
            sGameObjectOrdinalDisplayInfo = sGameObjectSchema.Columns.IndexOf("display_info");
            sGameObjectOrdinalLockId = sGameObjectSchema.Columns.IndexOf("lock_id");
            sGameObjectOrdinalPostedId = sGameObjectSchema.Columns.IndexOf("posted_id");
            sGameObjectOrdinalUpdatedId = sGameObjectSchema.Columns.IndexOf("updated_id");
            sGameObjectOrdinalPosted = sGameObjectSchema.Columns.IndexOf("posted");
            sGameObjectOrdinalUpdated = sGameObjectSchema.Columns.IndexOf("updated");
        }

        /**
         * Publically exposed method for updating cached game objects
         * 
         * @param  pUserId       the id of the user sending the update
         * @param  pHost         the host of the user updating in IP format
         * @param  pVersion      the wow version
         * @param  pLocale       the locale
         * @param  pGameObjects  the list of game objects contained in the update
         */
        public static void UpdateCachedGameObjects(Int32 pUserId,
                                                   String pHost,
                                                   UInt16 pVersion,
                                                   ELocale pLocale,
                                                   PackableList<WGOBObject> pGameObjects)
        {

#if ALPHA
            CPUMonitor monitorTotal = new CPUMonitor("UpdateCachedGameObjects for {0} entries", pGameObjects.Count);
#endif

            if (pGameObjects.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtInsert = sGameObjectSchema.Clone();
            DataTable dtUpdate = sGameObjectSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pLocale.ToString();
            using (SqlConnection conn = new SqlConnection(Config.Instance.WoWDB))
            {
                conn.Open();
                SqlBulkCopy bulkInsert = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                SqlBulkCopy bulkUpdate = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                bulkInsert.BatchSize = 5000;
                bulkUpdate.BatchSize = 5000;
                bulkInsert.DestinationTableName = "gameobject";
                bulkUpdate.DestinationTableName = "#gameobject";

                foreach (WGOBObject obj in pGameObjects)
                {
                    if (!ReadyForDB(sGameObjectHistory,
                                    sGameObjectConfirmations,
                                    obj.Id,
                                    Config.Instance.GameObjectExpiration,
                                    Config.Instance.MinConfirmations,
                                    pUserId,
                                    pVersion,
                                    pLocale))
                    {
                        continue;
                    }

                    key = new CustomKey(pVersion,
                                        obj.Id);

                    if (sGameObjectHash.Contains(key))
                    {
                        dr = dtUpdate.NewRow();
                    }
                    else
                    {
                        dr = dtInsert.NewRow();
                    }

                    dr[sGameObjectOrdinalId] = obj.Id;
                    dr[sGameObjectOrdinalVersionId] = pVersion;
                    dr[sGameObjectOrdinalType] = obj.Type;
                    dr[sGameObjectOrdinalDisplayInfo] = obj.DisplayInfo;
                    dr["name_" + locale] = obj.Name;
                    dr[sGameObjectOrdinalLockId] = obj.LockId;
                    dr[sGameObjectOrdinalPostedId] = pUserId;
                    dr[sGameObjectOrdinalUpdatedId] = pUserId;
                    dr[sGameObjectOrdinalPosted] = DateTime.UtcNow;
                    dr[sGameObjectOrdinalUpdated] = DateTime.UtcNow;

                    if (sGameObjectHash.Contains(key))
                    {
                        dtUpdate.Rows.Add(dr);
                    }
                    else
                    {
                        sGameObjectHash.Add(key);
                        dtInsert.Rows.Add(dr);
                    }
                }

                if (dtInsert.Rows.Count > 0)
                {
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedGameObjects Bulk Insert Copy");
#endif
                    bulkInsert.WriteToServer(dtInsert);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());
#endif
                }

                if (dtUpdate.Rows.Count > 0)
                {
                    SqlCommand cmd = conn.CreateCommand();
                    cmd.CommandText = "SELECT TOP 0 * INTO #gameobject FROM gameobject;";
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "CREATE CLUSTERED INDEX PK_gameobject ON #gameobject(id,version_id);";
                    cmd.ExecuteNonQuery();

#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedGameObjects Bulk Update Copy");
#endif
                    bulkUpdate.WriteToServer(dtUpdate);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());

                    CPUMonitor monitorTemp = new CPUMonitor("UpdateCachedGameObjects Update From Temp");
#endif

                    cmd.CommandText = String.Format(sCachedGameObjectUpdateQueryFormat,
                                                    locale);
                    cmd.ExecuteNonQuery();

#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorTemp.ToString());
#endif

                    cmd.CommandText = "DROP TABLE #gameobject;";
                    cmd.ExecuteNonQuery();
                }
            }

#if ALPHA
            Logger.Log(ELogLevel.Debug,
                       pHost,
                       monitorTotal.ToString());
#endif
        }


        private static Int32 sGameObjectOrdinalId = 0;
        private static Int32 sGameObjectOrdinalVersionId = 0;
        private static Int32 sGameObjectOrdinalType = 0;
        private static Int32 sGameObjectOrdinalDisplayInfo = 0;
        private static Int32 sGameObjectOrdinalLockId = 0;
        private static Int32 sGameObjectOrdinalPostedId = 0;
        private static Int32 sGameObjectOrdinalUpdatedId = 0;
        private static Int32 sGameObjectOrdinalPosted = 0;
        private static Int32 sGameObjectOrdinalUpdated = 0;
    }
}
