﻿using Curse;
using Curse.WoW;
using Curse.WoW.WDB;
using WoWDataCenter.DBC;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace WoWDataCenter
{
    public static partial class DB
    {
        public static void LoadItemSchemaOrdinals()
        {
            sItemOrdinalId = sItemSchema.Columns.IndexOf("id");
            sItemOrdinalVersionId = sItemSchema.Columns.IndexOf("version_id");
            sItemOrdinalClass = sItemSchema.Columns.IndexOf("item_class");
            sItemOrdinalSubClass = sItemSchema.Columns.IndexOf("item_sub_class");
            sItemOrdinalDisplay = sItemSchema.Columns.IndexOf("display");
            sItemOrdinalQuality = sItemSchema.Columns.IndexOf("quality");
            sItemOrdinalType = sItemSchema.Columns.IndexOf("item_type");
            sItemOrdinalBuyPrice = sItemSchema.Columns.IndexOf("buy_price");
            sItemOrdinalSellPrice = sItemSchema.Columns.IndexOf("sell_price");
            sItemOrdinalSlot = sItemSchema.Columns.IndexOf("slot");
            sItemOrdinalRequiredClass = sItemSchema.Columns.IndexOf("required_class");
            sItemOrdinalRequiredRace = sItemSchema.Columns.IndexOf("required_race");
            sItemOrdinalLevel = sItemSchema.Columns.IndexOf("level");
            sItemOrdinalRequiredLevel = sItemSchema.Columns.IndexOf("required_level");
            sItemOrdinalRequiredSkillId = sItemSchema.Columns.IndexOf("required_skill_id");
            sItemOrdinalRequiredSkillLevel = sItemSchema.Columns.IndexOf("required_skill_level");
            sItemOrdinalRequiredSpellId = sItemSchema.Columns.IndexOf("required_spell_id");
            sItemOrdinalRequiredRank = sItemSchema.Columns.IndexOf("required_rank");
            sItemOrdinalRequiredFaction = sItemSchema.Columns.IndexOf("required_faction");
            sItemOrdinalRequiredFactionLevel = sItemSchema.Columns.IndexOf("required_faction_level");
            sItemOrdinalStackUnique = sItemSchema.Columns.IndexOf("stack_unique");
            sItemOrdinalStackNormal = sItemSchema.Columns.IndexOf("stack_normal");
            sItemOrdinalContainerSlots = sItemSchema.Columns.IndexOf("container_slots");
            sItemOrdinalStat = sItemSchema.Columns.IndexOf("stat_1");
            sItemOrdinalStatValue = sItemSchema.Columns.IndexOf("stat_1_value");
            sItemOrdinalSpell = sItemSchema.Columns.IndexOf("spell_1");
            sItemOrdinalSpellTrigger = sItemSchema.Columns.IndexOf("spell_1_trigger");
            sItemOrdinalSpellCharges = sItemSchema.Columns.IndexOf("spell_1_charges");
            sItemOrdinalSpellCooldown = sItemSchema.Columns.IndexOf("spell_1_cooldown");
            sItemOrdinalSpellCategory = sItemSchema.Columns.IndexOf("spell_1_category");
            sItemOrdinalSpellCategoryCooldown = sItemSchema.Columns.IndexOf("spell_1_category_cooldown");
            sItemOrdinalDamageMin = sItemSchema.Columns.IndexOf("damage_1_min");
            sItemOrdinalDamageMax = sItemSchema.Columns.IndexOf("damage_1_max");
            sItemOrdinalDamageType = sItemSchema.Columns.IndexOf("damage_1_type");
            sItemOrdinalResistPhysical = sItemSchema.Columns.IndexOf("resist_physical");
            sItemOrdinalResistHoly = sItemSchema.Columns.IndexOf("resist_holy");
            sItemOrdinalResistFire = sItemSchema.Columns.IndexOf("resist_fire");
            sItemOrdinalResistNature = sItemSchema.Columns.IndexOf("resist_nature");
            sItemOrdinalResistFrost = sItemSchema.Columns.IndexOf("resist_frost");
            sItemOrdinalResistShadow = sItemSchema.Columns.IndexOf("resist_shadow");
            sItemOrdinalResistArcane = sItemSchema.Columns.IndexOf("resist_arcane");
            sItemOrdinalWeaponSpeed = sItemSchema.Columns.IndexOf("weapon_speed");
            sItemOrdinalAmmoType = sItemSchema.Columns.IndexOf("ammo_type");
            sItemOrdinalRangeModifier = sItemSchema.Columns.IndexOf("range_modifier");
            sItemOrdinalBond = sItemSchema.Columns.IndexOf("bond");
            sItemOrdinalBookText = sItemSchema.Columns.IndexOf("book_text");
            sItemOrdinalBookPages = sItemSchema.Columns.IndexOf("book_pages");
            sItemOrdinalBookStationary = sItemSchema.Columns.IndexOf("book_stationary");
            sItemOrdinalBeginQuest = sItemSchema.Columns.IndexOf("begin_quest");
            sItemOrdinalRequiredLockpickLevel = sItemSchema.Columns.IndexOf("required_lockpick_level");
            sItemOrdinalMaterial = sItemSchema.Columns.IndexOf("material");
            sItemOrdinalSheath = sItemSchema.Columns.IndexOf("sheath");
            sItemOrdinalRandom1Property = sItemSchema.Columns.IndexOf("random_1_property");
            sItemOrdinalRandom2Property = sItemSchema.Columns.IndexOf("random_2_property");
            sItemOrdinalBlock = sItemSchema.Columns.IndexOf("block");
            sItemOrdinalItemSet = sItemSchema.Columns.IndexOf("itemset");
            sItemOrdinalDurability = sItemSchema.Columns.IndexOf("durability");
            sItemOrdinalArea = sItemSchema.Columns.IndexOf("area");
            sItemOrdinalAreaMap = sItemSchema.Columns.IndexOf("area_map");
            sItemOrdinalBagFamilyId = sItemSchema.Columns.IndexOf("bag_family_id");
            sItemOrdinalTotemCategory = sItemSchema.Columns.IndexOf("totem_category");
            sItemOrdinalSocket1Color = sItemSchema.Columns.IndexOf("socket_1_color");
            sItemOrdinalSocket2Color = sItemSchema.Columns.IndexOf("socket_2_color");
            sItemOrdinalSocket3Color = sItemSchema.Columns.IndexOf("socket_3_color");
            sItemOrdinalSpellItemEnchantment = sItemSchema.Columns.IndexOf("spell_item_enchantment");
            sItemOrdinalGemProperties = sItemSchema.Columns.IndexOf("gem_properties");
            sItemOrdinalItemExtendedCost = sItemSchema.Columns.IndexOf("item_extended_cost");
            sItemOrdinalItemCondExtendedCost = sItemSchema.Columns.IndexOf("item_condextended_cost");
            sItemOrdinalDisenchantSkillLevel = sItemSchema.Columns.IndexOf("disenchant_skill_level");
            sItemOrdinalArmorDamageModifier = sItemSchema.Columns.IndexOf("armor_damage_modifier");
            sItemOrdinalPostedId = sItemSchema.Columns.IndexOf("posted_id");
            sItemOrdinalUpdatedId = sItemSchema.Columns.IndexOf("updated_id");
            sItemOrdinalPosted = sItemSchema.Columns.IndexOf("posted");
            sItemOrdinalUpdated = sItemSchema.Columns.IndexOf("updated");
            sItemOrdinalStatDistrbutionId = sItemSchema.Columns.IndexOf("stat_distribution_id");
            sItemOrdinalScalingStatMask = sItemSchema.Columns.IndexOf("scaling_stat_mask");
        }

        /**
         * Publically exposed method for updating cached items
         * 
         * @param  pUserId   the id of the user sending the update
         * @param  pHost     the host of the user updating in IP format
         * @param  pVersion  the wow version
         * @param  pLocale   the locale
         * @param  pItems    the list of items contained in the update
         */
        public static void UpdateCachedItems(Int32 pUserId,
                                             String pHost,
                                             UInt16 pVersion,
                                             ELocale pLocale,
                                             PackableList<WIDBItem> pItems)
        {

#if ALPHA
            CPUMonitor monitorTotal = new CPUMonitor("UpdateCachedItems for {0} entries", pItems.Count);
#endif

            if (pItems.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtInsert = sItemSchema.Clone();
            DataTable dtUpdate = sItemSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pLocale.ToString();
            using (SqlConnection conn = new SqlConnection(Config.Instance.WoWDB))
            {
                conn.Open();
                SqlBulkCopy bulkInsert = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                SqlBulkCopy bulkUpdate = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                bulkInsert.BatchSize = 5000;
                bulkUpdate.BatchSize = 5000;
                bulkInsert.DestinationTableName = "item";
                bulkUpdate.DestinationTableName = "#item";

                foreach (WIDBItem item in pItems)
                {
                    if (!ReadyForDB(sItemHistory,
                                    sItemConfirmations,
                                    item.Id,
                                    Config.Instance.ItemExpiration,
                                    Config.Instance.MinConfirmations,
                                    pUserId,
                                    pVersion,
                                    pLocale))
                    {
                        continue;
                    }

                    key = new CustomKey(pVersion,
                                        item.Id);

                    if (sItemHash.Contains(key))
                    {
                        dr = dtUpdate.NewRow();
                    }
                    else
                    {
                        dr = dtInsert.NewRow();
                    }

                    dr[sItemOrdinalId] = item.Id;
                    dr[sItemOrdinalVersionId] = pVersion;
                    dr["name_" + locale] = item.Name;
                    dr["description_" + locale] = item.Description;
                    dr[sItemOrdinalClass] = item.ClassId;
                    dr[sItemOrdinalSubClass] = item.SubClassId;
                    dr[sItemOrdinalDisplay] = item.DisplayId;
                    dr[sItemOrdinalQuality] = item.QualityId;
                    dr[sItemOrdinalType] = item.Type;
                    dr[sItemOrdinalBuyPrice] = item.BuyPrice;
                    dr[sItemOrdinalSellPrice] = item.SellPrice;
                    dr[sItemOrdinalSlot] = item.InventorySlot;
                    dr[sItemOrdinalRequiredClass] = item.Classes;
                    dr[sItemOrdinalRequiredRace] = item.Races;
                    dr[sItemOrdinalLevel] = item.Level;
                    dr[sItemOrdinalRequiredLevel] = item.RequiredLevel;
                    dr[sItemOrdinalRequiredSkillId] = item.RequiredSkill;
                    dr[sItemOrdinalRequiredSkillLevel] = item.RequiredSkillLevel;
                    dr[sItemOrdinalRequiredSpellId] = item.RequiredSpell;
                    dr[sItemOrdinalRequiredRank] = item.RequiredRank;
                    dr[sItemOrdinalRequiredFaction] = item.RequiredFaction;
                    dr[sItemOrdinalRequiredFactionLevel] = item.RequiredFactionLevel;
                    if (item.MaxUnique > UInt16.MaxValue)
                    {
                        dr[sItemOrdinalStackUnique] = 1;
                    }
                    else
                    {
                        dr[sItemOrdinalStackUnique] = item.MaxUnique;
                    }
                    
                    if (item.MaxStackSize > UInt16.MaxValue)
                    {
                        dr[sItemOrdinalStackNormal] = 1;
                    }
                    else
                    {
                        dr[sItemOrdinalStackNormal] = item.MaxStackSize;
                    }
                    
                    dr[sItemOrdinalContainerSlots] = item.ContainerSlots;

                    // For Heirloom Items:
                    if (item.QualityId == 7)
                    {
                        dr[sItemOrdinalStatDistrbutionId] = item.Statistics[0].Id;
                        dr[sItemOrdinalScalingStatMask] = item.Statistics[0].Value;
                    }
                    else
                    {
                        dr[sItemOrdinalStatDistrbutionId] = 0;
                        dr[sItemOrdinalScalingStatMask] = 0;
                    }
                    
                    for (Int32 index = 0; index < 10; ++index)
                    {
                        // Reset stats to 0 for heirloom items:
                        if (item.QualityId != 7 && index < item.Statistics.Count)
                        {
                            dr[sItemOrdinalStat + (index * 2)] = item.Statistics[index].Id;
                            dr[sItemOrdinalStatValue + (index * 2)] = item.Statistics[index].Value;
                        }
                        else
                        {
                            dr[sItemOrdinalStat + (index * 2)] = 0;
                            dr[sItemOrdinalStatValue + (index * 2)] = 0;
                        }
                    }
                    

                    // Item Spells:
                    for (Int32 index = 0; index < 5; ++index)
                    {
                        if (index < item.Spells.Count)
                        {
                            dr[sItemOrdinalSpell + (index * 6)] = item.Spells[index].Id;
                            dr[sItemOrdinalSpellTrigger + (index * 6)] = item.Spells[index].Trigger;
                            dr[sItemOrdinalSpellCharges + (index * 6)] = item.Spells[index].Charges;
                            dr[sItemOrdinalSpellCooldown + (index * 6)] = item.Spells[index].Cooldown;
                            dr[sItemOrdinalSpellCategory + (index * 6)] = item.Spells[index].Category;
                            dr[sItemOrdinalSpellCategoryCooldown + (index * 6)] = item.Spells[index].CategoryCooldown;
                        }
                        else
                        {
                            dr[sItemOrdinalSpell + (index * 6)] = 0;
                            dr[sItemOrdinalSpellTrigger + (index * 6)] = 0;
                            dr[sItemOrdinalSpellCharges + (index * 6)] = 0;
                            dr[sItemOrdinalSpellCooldown + (index * 6)] = 0;
                            dr[sItemOrdinalSpellCategory + (index * 6)] = 0;
                            dr[sItemOrdinalSpellCategoryCooldown + (index * 6)] = 0;
                        }
                    }
                    for (Int32 index = 0; index < 5; ++index)
                    {
                        if (index < item.Damages.Count)
                        {
                            dr[sItemOrdinalDamageMin + (index * 3)] = item.Damages[index].Min;
                            dr[sItemOrdinalDamageMax + (index * 3)] = item.Damages[index].Max;
                            dr[sItemOrdinalDamageType + (index * 3)] = item.Damages[index].Type;
                        }
                        else
                        {
                            dr[sItemOrdinalDamageMin + (index * 3)] = 0;
                            dr[sItemOrdinalDamageMax + (index * 3)] = 0;
                            dr[sItemOrdinalDamageType + (index * 3)] = 0;
                        }
                    }

                    dr[sItemOrdinalResistPhysical] = item.PhysicalResistance;
                    dr[sItemOrdinalResistHoly] = item.HolyResistance;
                    dr[sItemOrdinalResistFire] = item.FireResistance;
                    dr[sItemOrdinalResistNature] = item.NatureResistance;
                    dr[sItemOrdinalResistFrost] = item.FrostResistance;
                    dr[sItemOrdinalResistShadow] = item.ShadowResistance;
                    dr[sItemOrdinalResistArcane] = item.ArcaneResistance;
                    dr[sItemOrdinalWeaponSpeed] = item.WeaponDelay;
                    dr[sItemOrdinalAmmoType] = item.AmmoType;
                    dr[sItemOrdinalRangeModifier] = item.RangeModifier;
                    dr[sItemOrdinalBond] = item.Bond;
                    dr[sItemOrdinalBookText] = item.BookText;
                    dr[sItemOrdinalBookPages] = item.BookPages;
                    dr[sItemOrdinalBookStationary] = item.BookStationary;
                    dr[sItemOrdinalBeginQuest] = item.BeginsQuest;
                    dr[sItemOrdinalRequiredLockpickLevel] = item.LockPickRequirement;
                    dr[sItemOrdinalMaterial] = item.Material;
                    dr[sItemOrdinalSheath] = item.Sheath;
                    dr[sItemOrdinalRandom1Property] = item.Random1Property;
                    dr[sItemOrdinalRandom2Property] = item.Random2Property;
                    dr[sItemOrdinalBlock] = item.BlockValue;
                    dr[sItemOrdinalItemSet] = item.Set;
                    dr[sItemOrdinalDurability] = item.Durability;
                    dr[sItemOrdinalArea] = item.Area;
                    dr[sItemOrdinalAreaMap] = item.Map;
                    dr[sItemOrdinalBagFamilyId] = item.BagFamily;
                    dr[sItemOrdinalTotemCategory] = item.TotemCategory;
                    dr[sItemOrdinalSocket1Color] = item.Socket1;
                    dr[sItemOrdinalSocket2Color] = item.Socket2;
                    dr[sItemOrdinalSocket3Color] = item.Socket3;
                    dr[sItemOrdinalSpellItemEnchantment] = item.Enchantment;
                    dr[sItemOrdinalGemProperties] = item.GemProperties;
                    dr[sItemOrdinalItemExtendedCost] = item.ExtendedCost;
                    dr[sItemOrdinalItemCondExtendedCost] = item.CondExtendedCost;
                    dr[sItemOrdinalDisenchantSkillLevel] = item.RequiredDisenchantSkillLevel;
                    dr[sItemOrdinalArmorDamageModifier] = item.ArmorDamageModifier;
                    dr[sItemOrdinalPostedId] = pUserId;
                    dr[sItemOrdinalUpdatedId] = pUserId;
                    dr[sItemOrdinalPosted] = DateTime.UtcNow;
                    dr[sItemOrdinalUpdated] = DateTime.UtcNow;

                    if (sItemHash.Contains(key))
                    {
                        dtUpdate.Rows.Add(dr);
                    }
                    else
                    {
                        sItemHash.Add(key);
                        dtInsert.Rows.Add(dr);
                    }
                }

                if (dtInsert.Rows.Count > 0)
                {
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedItems Bulk Insert Copy");
#endif
                    bulkInsert.WriteToServer(dtInsert);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());
#endif
                }

                if (dtUpdate.Rows.Count > 0)
                {
                    SqlCommand cmd = conn.CreateCommand();
                    cmd.CommandText = "SELECT TOP 0 * INTO #item FROM item;";
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "CREATE CLUSTERED INDEX PK_item ON #item(id,version_id);";
                    cmd.ExecuteNonQuery();
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedItems Bulk Update Copy");
#endif
                    bulkUpdate.WriteToServer(dtUpdate);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());

                    CPUMonitor monitorTemp = new CPUMonitor("UpdateCachedItems Update From Temp");
#endif

                    cmd.CommandText = String.Format(sCachedItemUpdateQueryFormat,
                                                    locale);
                    cmd.ExecuteNonQuery();
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorTemp.ToString());
#endif

                    cmd.CommandText = "DROP TABLE #item;";
                    cmd.ExecuteNonQuery();
                }
            }
#if ALPHA
            Logger.Log(ELogLevel.Debug,
                       pHost,
                       monitorTotal.ToString());
#endif
        }


        private static Int32 sItemOrdinalId = 0;
        private static Int32 sItemOrdinalVersionId = 0;
        private static Int32 sItemOrdinalClass = 0;
        private static Int32 sItemOrdinalSubClass = 0;
        private static Int32 sItemOrdinalDisplay = 0;
        private static Int32 sItemOrdinalQuality = 0;
        private static Int32 sItemOrdinalType = 0;
        private static Int32 sItemOrdinalBuyPrice = 0;
        private static Int32 sItemOrdinalSellPrice = 0;
        private static Int32 sItemOrdinalSlot = 0;
        private static Int32 sItemOrdinalRequiredClass = 0;
        private static Int32 sItemOrdinalRequiredRace = 0;
        private static Int32 sItemOrdinalLevel = 0;
        private static Int32 sItemOrdinalRequiredLevel = 0;
        private static Int32 sItemOrdinalRequiredSkillId = 0;
        private static Int32 sItemOrdinalRequiredSkillLevel = 0;
        private static Int32 sItemOrdinalRequiredSpellId = 0;
        private static Int32 sItemOrdinalRequiredRank = 0;
        private static Int32 sItemOrdinalRequiredFaction = 0;
        private static Int32 sItemOrdinalRequiredFactionLevel = 0;
        private static Int32 sItemOrdinalStackUnique = 0;
        private static Int32 sItemOrdinalStackNormal = 0;
        private static Int32 sItemOrdinalContainerSlots = 0;
        private static Int32 sItemOrdinalStat = 0;
        private static Int32 sItemOrdinalStatValue = 0;
        private static Int32 sItemOrdinalSpell = 0;
        private static Int32 sItemOrdinalSpellTrigger = 0;
        private static Int32 sItemOrdinalSpellCharges = 0;
        private static Int32 sItemOrdinalSpellCooldown = 0;
        private static Int32 sItemOrdinalSpellCategory = 0;
        private static Int32 sItemOrdinalSpellCategoryCooldown = 0;
        private static Int32 sItemOrdinalDamageMin = 0;
        private static Int32 sItemOrdinalDamageMax = 0;
        private static Int32 sItemOrdinalDamageType = 0;
        private static Int32 sItemOrdinalResistPhysical = 0;
        private static Int32 sItemOrdinalResistHoly = 0;
        private static Int32 sItemOrdinalResistFire = 0;
        private static Int32 sItemOrdinalResistNature = 0;
        private static Int32 sItemOrdinalResistFrost = 0;
        private static Int32 sItemOrdinalResistShadow = 0;
        private static Int32 sItemOrdinalResistArcane = 0;
        private static Int32 sItemOrdinalWeaponSpeed = 0;
        private static Int32 sItemOrdinalAmmoType = 0;
        private static Int32 sItemOrdinalRangeModifier = 0;
        private static Int32 sItemOrdinalBond = 0;
        private static Int32 sItemOrdinalBookText = 0;
        private static Int32 sItemOrdinalBookPages = 0;
        private static Int32 sItemOrdinalBookStationary = 0;
        private static Int32 sItemOrdinalBeginQuest = 0;
        private static Int32 sItemOrdinalRequiredLockpickLevel = 0;
        private static Int32 sItemOrdinalMaterial = 0;
        private static Int32 sItemOrdinalSheath = 0;
        private static Int32 sItemOrdinalRandom1Property = 0;
        private static Int32 sItemOrdinalRandom2Property = 0;
        private static Int32 sItemOrdinalBlock = 0;
        private static Int32 sItemOrdinalItemSet = 0;
        private static Int32 sItemOrdinalDurability = 0;
        private static Int32 sItemOrdinalArea = 0;
        private static Int32 sItemOrdinalAreaMap = 0;
        private static Int32 sItemOrdinalBagFamilyId = 0;
        private static Int32 sItemOrdinalTotemCategory = 0;
        private static Int32 sItemOrdinalSocket1Color = 0;
        private static Int32 sItemOrdinalSocket2Color = 0;
        private static Int32 sItemOrdinalSocket3Color = 0;
        private static Int32 sItemOrdinalSpellItemEnchantment = 0;
        private static Int32 sItemOrdinalGemProperties = 0;
        private static Int32 sItemOrdinalItemExtendedCost = 0;
        private static Int32 sItemOrdinalItemCondExtendedCost = 0;
        private static Int32 sItemOrdinalDisenchantSkillLevel = 0;
        private static Int32 sItemOrdinalArmorDamageModifier = 0;
        private static Int32 sItemOrdinalPostedId = 0;
        private static Int32 sItemOrdinalUpdatedId = 0;
        private static Int32 sItemOrdinalPosted = 0;
        private static Int32 sItemOrdinalUpdated = 0;
        private static Int32 sItemOrdinalStatDistrbutionId = 0;
        private static Int32 sItemOrdinalScalingStatMask = 0;
    }
}
