﻿using Curse;
using Curse.WoW;
using Curse.WoW.WDB;
using WoWDataCenter.DBC;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace WoWDataCenter
{
    public static partial class DB
    {
        public static void LoadPageTextSchemaOrdinals()
        {
            sPageTextOrdinalId = sPageTextSchema.Columns.IndexOf("id");
            sPageTextOrdinalVersionId = sPageTextSchema.Columns.IndexOf("version_id");
            sPageTextOrdinalNextPageId = sPageTextSchema.Columns.IndexOf("next_page_id");
            sPageTextOrdinalPostedId = sPageTextSchema.Columns.IndexOf("posted_id");
            sPageTextOrdinalUpdatedId = sPageTextSchema.Columns.IndexOf("updated_id");
            sPageTextOrdinalPosted = sPageTextSchema.Columns.IndexOf("posted");
            sPageTextOrdinalUpdated = sPageTextSchema.Columns.IndexOf("updated");
        }

        /**
         * Publically exposed method for updating cached page texts
         * 
         * @param  pUserId     the id of the user sending the update
         * @param  pHost       the host of the user updating in IP format
         * @param  pVersion    the wow version
         * @param  pLocale     the locale
         * @param  pPageTexts  the list of page texts contained in the update
         */
        public static void UpdateCachedPageTexts(Int32 pUserId,
                                                 String pHost,
                                                 UInt16 pVersion,
                                                 ELocale pLocale,
                                                 PackableList<WPTXPage> pPageTexts)
        {

#if ALPHA
            CPUMonitor monitorTotal = new CPUMonitor("UpdateCachedPageTexts for {0} entries", pPageTexts.Count);
#endif

            if (pPageTexts.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtInsert = sPageTextSchema.Clone();
            DataTable dtUpdate = sPageTextSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pLocale.ToString();
            using (SqlConnection conn = new SqlConnection(Config.Instance.WoWDB))
            {
                conn.Open();
                SqlBulkCopy bulkInsert = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                SqlBulkCopy bulkUpdate = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                bulkInsert.BatchSize = 5000;
                bulkUpdate.BatchSize = 5000;
                bulkInsert.DestinationTableName = "pagetext";
                bulkUpdate.DestinationTableName = "#pagetext";

                foreach (WPTXPage page in pPageTexts)
                {
                    if (!ReadyForDB(sPageTextHistory,
                                    sPageTextConfirmations,
                                    page.Id,
                                    Config.Instance.PageTextExpiration,
                                    Config.Instance.MinConfirmations,
                                    pUserId,
                                    pVersion,
                                    pLocale))
                    {
                        continue;
                    }

                    key = new CustomKey(pVersion,
                                        page.Id);

                    if (sPageTextHash.Contains(key))
                    {
                        dr = dtUpdate.NewRow();
                    }
                    else
                    {
                        dr = dtInsert.NewRow();
                    }

                    dr[sPageTextOrdinalId] = page.Id;
                    dr[sPageTextOrdinalVersionId] = pVersion;
                    dr["text_" + locale] = page.Text;
                    dr[sPageTextOrdinalNextPageId] = page.NextPage;
                    dr[sPageTextOrdinalPostedId] = pUserId;
                    dr[sPageTextOrdinalUpdatedId] = pUserId;
                    dr[sPageTextOrdinalPosted] = DateTime.UtcNow;
                    dr[sPageTextOrdinalUpdated] = DateTime.UtcNow;

                    if (sPageTextHash.Contains(key))
                    {
                        dtUpdate.Rows.Add(dr);
                    }
                    else
                    {
                        sPageTextHash.Add(key);
                        dtInsert.Rows.Add(dr);
                    }
                }

                if (dtInsert.Rows.Count > 0)
                {
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedPageTexts Bulk Insert Copy");
#endif
                    bulkInsert.WriteToServer(dtInsert);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());
#endif
                }

                if (dtUpdate.Rows.Count > 0)
                {
                    SqlCommand cmd = conn.CreateCommand();
                    cmd.CommandText = "SELECT TOP 0 * INTO #pagetext FROM pagetext;";
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "CREATE CLUSTERED INDEX PK_pagetext ON #pagetext(id,version_id);";
                    cmd.ExecuteNonQuery();
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedPageTexts Bulk Update Copy");
#endif
                    bulkUpdate.WriteToServer(dtUpdate);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());

                    CPUMonitor monitorTemp = new CPUMonitor("UpdateCachedPageTexts Update From Temp");
#endif
                    cmd.CommandText = String.Format(sCachedPageTextUpdateQueryFormat,
                                                    locale);
                    cmd.ExecuteNonQuery();
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorTemp.ToString());
#endif

                    cmd.CommandText = "DROP TABLE #pagetext;";
                    cmd.ExecuteNonQuery();
                }
            }
#if ALPHA
            Logger.Log(ELogLevel.Debug,
                       pHost,
                       monitorTotal.ToString());
#endif
        }


        private static Int32 sPageTextOrdinalId = 0;
        private static Int32 sPageTextOrdinalVersionId = 0;
        private static Int32 sPageTextOrdinalNextPageId = 0;
        private static Int32 sPageTextOrdinalPostedId = 0;
        private static Int32 sPageTextOrdinalUpdatedId = 0;
        private static Int32 sPageTextOrdinalPosted = 0;
        private static Int32 sPageTextOrdinalUpdated = 0;
    }
}
