﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using Curse.TypeScriptSharp.Model;

namespace Curse.TypeScriptSharp
{
    public abstract class CodeGenerator
    {
        public virtual string GetTypeName(Type outerType, HashSet<Type> knownTypes, Type propertyType)
        {
            throw new NotImplementedException();
        }

        public void WriteInterface(HashSet<Type> knownTypes, StringBuilder sb, Type type)
        {
            var sanitizedTypeName= ServiceContractHelper.GetContractTypeName(type);

            // Properties
            var props = type.GetProperties(BindingFlags.Public | BindingFlags.Instance);
            var definition = new InterfaceDefinition
            {
                Name = sanitizedTypeName,
                Namespace = type.Namespace,
                Properties = props.Select(
                    prop => new PropertyDefinition
                    {
                        Name = prop.Name,                        
                        TypeName = GetTypeName(type, knownTypes, prop.PropertyType),
                        IsOptional = prop.PropertyType.IsGenericType && prop.PropertyType.GetGenericTypeDefinition() == typeof(Nullable<>)
                    }).ToList()
            };

            WriteInterface(sb, definition);
        }

        public virtual void WriteInterface(StringBuilder sb, InterfaceDefinition definition)
        {
            throw new NotImplementedException();
        }
    }
}
