﻿
using System;
using System.Collections.Generic;
using System.Text;
using Curse.TypeScriptSharp.Model;
using Microsoft.SqlServer.Server;

namespace Curse.TypeScriptSharp
{
    public interface ICodeGenerator
    {
        void WriteEnum(StringBuilder sb, Type type);
        void WriteImport(StringBuilder sb, string importNamespace);
        void WriteInterface(HashSet<Type> knownTypes, StringBuilder sb, Type type);
        void WriteInterface(StringBuilder sb, InterfaceDefinition definition);
        void WriteImports(HashSet<Type> knownTypes, StringBuilder sb, string excludeNamespace = null, string path = "models/");
        void WriteOperation(StringBuilder methodBuilder, OperationDefinition operationDefinition);
        string GetTypeName(Type outerType, HashSet<Type> knownTypes, Type propertyType);
        void WriteWebApiMethod(StringBuilder sb, HashSet<Type> knownTypes, WebApiMethodInfo methodInfo);
        void WriteModuleHeader(StringBuilder sb, string moduleNamespace, string moduleName);
        void WriteModuleFooter(StringBuilder sb);
        string FileExtension { get; }
        bool ExportAllKnownTypes { get; }
        string GetUrlToken(string paramName, int ordinal);
        string GetRpcName(string methodName);
        HashSet<string> OverrideImports { get; }

    }
}
