﻿using System;
using System.Collections.Generic;
using System.Reflection;
namespace Curse.TypeScriptSharp
{
   public static class TypeExplorer
    {
       public static void Explore(string namespaceFilter, HashSet<Type> knownTypes, Type type, HashSet<Type> exploredTypes)
       {
           if (exploredTypes.Contains(type))
           {
               return;
           }

           exploredTypes.Add(type);

           if (type.IsArray)
           {
               type = type.GetElementType();
           }


           if (type.IsGenericType)
           {
               foreach (var subType in type.GenericTypeArguments)
               {
                   Explore(namespaceFilter, knownTypes, subType, exploredTypes);
               }
           }

           if (!type.FullName.StartsWith(namespaceFilter))
           {
               return;
           }

           knownTypes.Add(type);

           var props = type.GetProperties(BindingFlags.Instance | BindingFlags.Public);
           foreach (var property in props)
           {
               Explore(namespaceFilter, knownTypes, property.PropertyType, exploredTypes);
           }
       }
    }
}
