﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Web.Http;

namespace Curse.TypeScriptSharp
{
    public class WebApiControllerInfo
    {
        private readonly ICodeGenerator _codeGenerator;
        private readonly Type _type;

        public string ControllerName { get; set; }

        public string RoutePrefix { get;  private set; }

        public WebApiControllerInfo(ICodeGenerator codeGenerator, Type type)
        {
            _codeGenerator = codeGenerator;
            _type = type;

            ControllerName = type.Name.Substring(0, type.Name.IndexOf("Controller"));
            
            var routePrefixAttribute = type.GetCustomAttribute<RoutePrefixAttribute>();
            RoutePrefix = routePrefixAttribute != null ? routePrefixAttribute.Prefix : string.Empty;
                
            var methods = new List<WebApiMethodInfo>();            
            var allMethods = _type.GetMethods(BindingFlags.Instance | BindingFlags.Public | BindingFlags.FlattenHierarchy);

            var excludeUnlessOverridden = type.GetCustomAttributes(true).Cast<Attribute>().Any(a => a.GetType().Name.Equals("ExcludeFromGeneratorAttribute"));

            var includedMethods = allMethods.Where(m =>
            {
                var allAttributes = new HashSet<Attribute>(m.GetCustomAttributes());

                if (!allAttributes.Any(p => p.GetType() == typeof (RouteAttribute)))
                {
                    return false;
                }

                if (allAttributes.Any(p => p.GetType().Name.Equals("ExcludeFromGeneratorAttribute")))
                {
                    return false;
                }

                if (excludeUnlessOverridden && allAttributes.All(p => !p.GetType().Name.Equals("IncludeInGeneratorAttribute")))
                {
                    return false;
                }

                return true;
            }).ToArray();

            if (includedMethods.Length == 0)
            {
                throw new InvalidOperationException("No generatable methods");
            }

            foreach (var method in includedMethods)
            {

                var allAttributes = new HashSet<Attribute>(method.GetCustomAttributes());

                if (!allAttributes.Any(p => p.GetType() == typeof(RouteAttribute)))
                {
                    continue;
                }

                if (allAttributes.Any(p => p.GetType().Name.Equals("ExcludeFromGeneratorAttribute")))
                {
                    continue;
                }

                if (excludeUnlessOverridden && allAttributes.All(p => !p.GetType().Name.Equals("IncludeInGeneratorAttribute")))
                {
                    continue;
                }

                Console.WriteLine("Discovered WebAPI method: " + method.Name);
                var methodInfo = new WebApiMethodInfo(_codeGenerator, this, method, false);
                methods.Add(methodInfo);

                var regionalMethodInfo = new WebApiMethodInfo(_codeGenerator, this, method, true);
                methods.Add(regionalMethodInfo);
            }

            Methods = methods.ToArray();
        }

        public WebApiMethodInfo[] Methods { get; set; }
     
        public void Generate(StringBuilder sb, HashSet<Type> knownTypes)
        {
            foreach (var method in Methods)
            {
                if (!method.CanBeGenerated)
                {
                    Console.WriteLine("Skipping method: " + method.RpcName);
                    continue;                    
                }
                method.Generate(sb, knownTypes);
            }   
        }
    }
}
