﻿using System;
using Curse.SocketInterface;
using Curse.SocketMessages;
using Curse.Voice.Contracts;

namespace Curse.Voice.Client
{
    public interface IVoiceClient : IDisposable
    {
        bool IsConnected { get; }

        int Port { get; }

        void Disconnect(SocketDisconnectReason reason);

        event EventHandler<SocketDisconnectEventArgs> Disconnected;

        string SessionID { get; }

        //string DisplayName { get; }

        //string AvatarUrl { get; }

        //int? UserID { get; }

        //string InGameName { get; }

        //string InGameRegion { get; }

        //string ClientVersion { get; }

        long? AccessToken { get; }

        //string AuthToken { get; }

        //CodecInfo CodecInfo { get; }

        ConnectionState ConnectionState { get; }

        event EventHandler<SocketDisconnectEventArgs> DisconnectedSession;

        event EventHandler<EventArgs<UserLeftNotification>> UserLeft;

        event EventHandler<EventArgs<UserJoinedNotification>> UserJoined;

        event EventHandler<EventArgs<UserUpdatedNotification>> UserUpdated;

        event EventHandler<EventArgs<TransmitStartNotification>> UserStartTransmission;

        event EventHandler<EventArgs<TransmitEndNotification>> UserEndTransmission;

        event EventHandler<EventArgs<TransmitNotification>> VoiceTranmission;

        event EventHandler<EventArgs<FailoverNotification>> Failover;

        event EventHandler<EventArgs<ChatMessageNotification>> ChatMessageReceived;

        event EventHandler<EventArgs<ChatMessageResponse>> ChatMessageResponse;

        event EventHandler<EventArgs<GetUsersResponse>> UserListUpdated;

        event EventHandler<EventArgs<TimeSpan>> PingUpdated;

        event EventHandler<EventArgs<UserDisconnectNotification>> UserDisconnected;

        event EventHandler<EventArgs<AddPendingUsersNotification>> AddPendingUsers;

        event EventHandler<EventArgs<RemovePendingUserNotification>> RemovePendingUsers;

        event EventHandler<EventArgs<VoiceInstanceChangedNotification>> VoiceInstanceChanged;

        //bool LoopbackEnabled { get; }

        //bool LocalLoopbackEnabled { get; }

        TimeSpan Ping { get; }

        void StartTransmit();

        void EndTransmit();

        void UpdateUser(string displayName, string avatarUrl, string ingameName, string ingameRegion);

        void Transmit(byte[] data);

        void SendChatMessage(string body);

        void GetUserList();

        void LeaveSession();
    }
}
