﻿using System;
using System.Net;
using Curse.Voice.Contracts;

namespace Curse.Voice.Client
{
    public class VoiceConnectionInfo
    {
        public string InviteUrl { get; set; }
        public string OriginalDisplayName { get; set; }
        public string DisplayName { get; set; }
        public int HostID { get; set; }
        public string HostName { get; set; }
        public IPAddress IPAddress { get; set; }
        public int Port { get; set; }
        public string InstanceID { get; set; }
        public int? UserID { get; set; }
        public int? GameID { get; set; }
        public string AvatarUrl { get; set; }
        public string InGameName { get; set; }
        public string InGameRegion { get; set; }
        public string RegionName { get; set; }

        public VoiceInstanceType SessionType { get; set; }

        public string AuthToken { get; set; }

        public long? AccessToken { get; set; }

        public CodecInfo CodecInfo { get; set; }

        public VoiceConnectionInfo(CodecInfo codecInfo)
        {
            CodecInfo = codecInfo;
        }

        // AdHoc
        public bool IsAdHoc { get { return SessionType == VoiceInstanceType.AdHoc; } }

        // AutoMatch
        public bool IsAutoMatch { get { return SessionType == VoiceInstanceType.AutoMatch; } }
        public long AutoMatchSessionID { get; set; }

        // Friend
        public bool IsFriend { get { return SessionType == VoiceInstanceType.Friend; } }
        public int FriendID { get; set; }

        // Group
        public bool IsGroup { get { return SessionType == VoiceInstanceType.Group; } }
        public Guid GroupID { get; set; }

        // Friend
        public bool IsMultiFriend { get { return SessionType == VoiceInstanceType.MultiFriend; } }

        public VoiceConnectionInfo Clone()
        {
            return (VoiceConnectionInfo)MemberwiseClone();
        }
    }
}
