﻿using Curse.Voice.Host;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Curse.Voice.HostManagement;

namespace Curse.Voice.ConsoleHost
{
    class Program
    {
        private static ServiceHost _host;

        static void Main(string[] args)
        {
            AppDomain.CurrentDomain.ProcessExit += new EventHandler(CurrentDomain_ProcessExit);           
        
            var hostManagementInstance = new CurseVoiceHostManagement();
            _host = TcpBindingHelper.CreateServiceHost<IVoiceHostManagement>(hostManagementInstance, "net.tcp://" + Environment.MachineName + ":81/management-service");
            _host.Open();
            Console.ReadKey();
            
        }

        static void CurrentDomain_ProcessExit(object sender, EventArgs e)
        {
            Console.WriteLine("Closing all open service hosts...");
            _host.Close();
            VoiceInstanceManager.Instance.Dispose();
            Console.WriteLine("Done");
        }
    }
}
