﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.Text;
using System.Threading.Tasks;
using Curse.Voice.Host;
using Curse.Voice.HostManagement;

namespace Curse.Voice.ConsoleHost
{
    public class VoiceInstanceManager : IDisposable
    {
        public static readonly VoiceInstanceManager Instance = new VoiceInstanceManager();
        private ConcurrentDictionary<string, ServiceHost> _voiceHostInstances = new ConcurrentDictionary<string, ServiceHost>();

        public void StartNewInstance(string instanceIdentifier, int ownerUserID)
        {
            var curseVoiceHost = new CurseVoiceHost();
            curseVoiceHost.VoiceInstance = new VoiceInstance(instanceIdentifier, ownerUserID);
            var host = TcpBindingHelper.CreateServiceHost<ICurseVoiceHost>(curseVoiceHost, "net.tcp://" + Environment.MachineName + ":81/" + instanceIdentifier);            
            host.Open();
            _voiceHostInstances.TryAdd(instanceIdentifier, host);                        
        }

        public void Dispose()
        {
            foreach (var instance in _voiceHostInstances.Values)
            {
                try
                {
                    instance.Close(TimeSpan.FromSeconds(10));
                }
                catch (Exception ex)
                {                    
                    Console.WriteLine("Failed to close voice host: " + ex.Message);
                }
                
            }
        }
    }
}
