﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Voice.Contracts
{
    public enum ChatMessageStatus
    {
        Successful = 1,        
        FloodControl,
        MessageTooLarge,
        Error
    }

    [ProtoContract]
    public class ChatMessageResponse : Contract<ChatMessageResponse>
    {
        [ProtoMember(1)]
        public ChatMessageStatus Status { get; set; }

        [ProtoMember(2)]
        public DateTime Timestamp
        {
            get;
            set;
        }

        [ProtoMember(3)]
        public Guid ClientID { get; set; }
    }
}
