﻿using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Voice.Contracts
{
    [ProtoContract]
    public class JoinSessionRequest : Contract<JoinSessionRequest>
    {
        [ProtoMember(1)]
        public string SessionID { get; set; }

        [ProtoMember(2)]
        public string AvatarUrl { get; set; }

        [ProtoMember(3)]
        public int? UserID { get; set; }

        [ProtoMember(4)]
        public string DisplayName { get; set; }

        [ProtoMember(5)]
        public string SmallAvatarUrl { get; set; }

        [ProtoMember(6)]
        public string InGameName { get; set; }

        [ProtoMember(7)]
        public string InGameRegion { get; set; }

        [ProtoMember(8)]
        public string ClientVersion { get; set; }

        [ProtoMember(9)]
        public string AuthToken { get; set; }

        [ProtoMember(10)]
        public long? AccessToken { get; set; }

        [ProtoMember(11)]
        public CodecInfo CodecInfo { get; set; }        

        [ProtoMember(12)]
        public MultiStreamType WebRTCType { get; set; }

        /// <summary>
        /// Set to true to indicate that this client supports video playback. If false no video packets will be forwarded.
        /// </summary>
        [ProtoMember(13)]
        public bool SupportsVideo { get; set; }

        /// <summary>
        /// If user is sending video, this specifies the format of that video. (SupportsVideo must be true)
        /// </summary>
        [ProtoMember(14)]
        public CodecInfo VideoCodec { get; set; }
    }

    public enum MultiStreamType
    {
        None,
        PlanA,
        PlanB,
        Unified,
        NullCipher,
    }
}
