﻿using System;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Voice.Contracts
{
    public enum JoinSessionStatus
    {
        Successful = 1,
        FailedNameAlreadyTaken,
        FailedUnhandledException,
        InvalidClientVersion,
        SessionNotFound,
        FailedSessionFull,
        Timeout,
        Throttled,
        Forbidden
    }

    [ProtoContract]
    public class JoinSessionResponse : Contract<JoinSessionResponse>
    {
        [ProtoMember(1)]
        public int ClientID { get; set; }

        [ProtoMember(2)]
        public VoiceSessionMember[] Users { get; set; }

        [ProtoMember(3)]
        public JoinSessionStatus Status { get; set; }

        [ProtoMember(4)]
        public int CurrentUserID { get; set; }
        
        [ProtoMember(5)]
        public VoiceInstanceType Type { get; set; }

        [ProtoMember(6)]
        public PendingUser[] PendingUsers { get; set; }

        [ProtoMember(7)]
        public DateTime Timestamp
        {
            get;
            set;
        }
    }
}
