﻿using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Voice.Contracts
{
    public enum RemovePendingUserReason
    {
        Declined,
        NoAnswer,
        Kicked,
        LeftGroup
    }

    [ProtoContract]
    public class RemovePendingUserNotification : Contract<RemovePendingUserNotification>
    {
        [ProtoMember(1)]
        public int UserID { get; set; }


        [ProtoMember(2)]
        public RemovePendingUserReason Reason { get; set; }
    }
}
