﻿using System;
using System.Collections.Generic;
using System.Diagnostics.Contracts;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.SocketMessages;
using ProtoBuf;
using Curse.SocketInterface;
using System.Security.Cryptography;

namespace Curse.Voice.Contracts
{
    
    public class TransmitNotification : Contract<TransmitNotification>
    {                
        public const int FixedSize = 20;

        public int SenderID { get; set; }        
        public UInt32 SequenceNumber { get; set; }
        public Int64 Timestamp { get; set; }        
        public int VoiceDataLength { get; set; }        
        public byte[] VoiceData { get; set; }

        public override Message ToMessage(int sessionID = 0, SymmetricAlgorithm encryptionAlgorithm = null)
        {
            VoiceDataLength = VoiceData.Length;
            var body = new byte[FixedSize + VoiceData.Length];
            body.SetBytesLE(SenderID, 0);
            body.SetBytesLE(SequenceNumber, 4);
            body.SetBytesLE(Timestamp, 8);
            body.SetBytesLE(VoiceDataLength, 16);
            Buffer.BlockCopy(VoiceData, 0, body, 20, VoiceData.Length);
            return Message.FromOutgoing(sessionID, body, MessageType, false);            
        }

        public override void ParseMessage(Message message)
        {
            var body = message.GetBody();
            SenderID = body.ToInt32LE(0);
            SequenceNumber = body.ToUInt32LE(4);
            Timestamp = body.ToInt64LE(8);
            VoiceDataLength = body.ToInt32LE(16);
            VoiceData = new byte[VoiceDataLength];
            Buffer.BlockCopy(body, FixedSize, VoiceData, 0, VoiceDataLength);
        }
        
    }
}
